/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.optimistic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.OptimisticIsolationTest;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MonotonicTest {
    private Repository repo;
    private RepositoryConnection a;
    private RepositoryConnection b;
    private IsolationLevel level = IsolationLevels.SNAPSHOT_READ;
    private String NS = "http://rdf.example.org/";
    private ValueFactory lf;
    private IRI PAINTER;
    private IRI PAINTS;
    private IRI PAINTING;
    private IRI YEAR;
    private IRI PERIOD;
    private IRI PICASSO;
    private IRI REMBRANDT;
    private IRI GUERNICA;
    private IRI JACQUELINE;
    private IRI NIGHTWATCH;
    private IRI ARTEMISIA;
    private IRI DANAE;
    private IRI JACOB;
    private IRI ANATOMY;
    private IRI BELSHAZZAR;

    @Before
    public void setUp() throws Exception {
        this.repo = OptimisticIsolationTest.getEmptyInitializedRepository(MonotonicTest.class);
        this.lf = this.repo.getValueFactory();
        ValueFactory uf = this.repo.getValueFactory();
        this.PAINTER = uf.createIRI(this.NS, "Painter");
        this.PAINTS = uf.createIRI(this.NS, "paints");
        this.PAINTING = uf.createIRI(this.NS, "Painting");
        this.YEAR = uf.createIRI(this.NS, "year");
        this.PERIOD = uf.createIRI(this.NS, "period");
        this.PICASSO = uf.createIRI(this.NS, "picasso");
        this.REMBRANDT = uf.createIRI(this.NS, "rembrandt");
        this.GUERNICA = uf.createIRI(this.NS, "guernica");
        this.JACQUELINE = uf.createIRI(this.NS, "jacqueline");
        this.NIGHTWATCH = uf.createIRI(this.NS, "nightwatch");
        this.ARTEMISIA = uf.createIRI(this.NS, "artemisia");
        this.DANAE = uf.createIRI(this.NS, "dana\u00eb");
        this.JACOB = uf.createIRI(this.NS, "jacob");
        this.ANATOMY = uf.createIRI(this.NS, "anatomy");
        this.BELSHAZZAR = uf.createIRI(this.NS, "belshazzar");
        this.a = this.repo.getConnection();
        this.b = this.repo.getConnection();
    }

    @After
    public void tearDown() throws Exception {
        this.a.close();
        this.b.close();
        this.repo.shutDown();
    }

    @Test
    public void test_independentPattern() throws Exception {
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        Assert.assertEquals((long)1L, (long)this.size(this.a, (Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
        Assert.assertEquals((long)1L, (long)this.size(this.b, (Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
        this.a.commit();
        this.b.commit();
        Assert.assertEquals((long)2L, (long)this.size(this.a, null, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
        Assert.assertEquals((long)2L, (long)this.size(this.b, null, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
    }

    @Test
    public void test_safePattern() throws Exception {
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        Assert.assertEquals((long)1L, (long)this.size(this.a, null, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
        this.a.commit();
        this.b.commit();
    }

    @Test
    public void test_afterPattern() throws Exception {
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        Assert.assertEquals((long)1L, (long)this.size(this.a, null, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
        this.a.commit();
        Assert.assertEquals((long)2L, (long)this.size(this.b, null, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
        this.b.commit();
    }

    @Test
    public void test_afterInsertDataPattern() throws Exception {
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.prepareUpdate(QueryLanguage.SPARQL, "INSERT DATA { <picasso> a <Painter> }", this.NS).execute();
        this.b.prepareUpdate(QueryLanguage.SPARQL, "INSERT DATA { <rembrandt> a <Painter> }", this.NS).execute();
        Assert.assertEquals((long)1L, (long)this.size(this.a, null, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
        this.a.commit();
        Assert.assertEquals((long)2L, (long)this.size(this.b, null, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
        this.b.commit();
    }

    @Test
    public void test_changedPattern() throws Exception {
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        Assert.assertEquals((long)1L, (long)this.size(this.b, null, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
        this.a.commit();
        Assert.assertEquals((long)2L, (long)this.size(this.b, null, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
        this.b.commit();
    }

    @Test
    public void test_safeQuery() throws Exception {
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        List<Value> result = this.eval("painting", this.b, "SELECT ?painting WHERE { [a <Painter>] <paints> ?painting }");
        for (Value painting : result) {
            this.b.add((Resource)painting, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        }
        this.a.commit();
        this.b.commit();
        Assert.assertEquals((long)9L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
        Assert.assertEquals((long)9L, (long)this.size(this.b, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_safeInsert() throws Exception {
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        this.b.prepareUpdate(QueryLanguage.SPARQL, "INSERT { ?painting a <Painting> }\nWHERE { [a <Painter>] <paints> ?painting }", this.NS).execute();
        this.a.commit();
        this.b.commit();
        Assert.assertEquals((long)9L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
        Assert.assertEquals((long)9L, (long)this.size(this.b, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_mergeQuery() throws Exception {
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        List<Value> result = this.eval("painting", this.b, "SELECT ?painting WHERE { [a <Painter>] <paints> ?painting }");
        for (Value painting : result) {
            this.b.add((Resource)painting, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        }
        this.a.commit();
        Assert.assertEquals((long)3L, (long)this.size(this.b, (Resource)this.REMBRANDT, this.PAINTS, null, false, new Resource[0]));
        this.b.commit();
        Assert.assertEquals((long)3L, (long)this.size(this.a, null, RDF.TYPE, (Value)this.PAINTING, false, new Resource[0]));
    }

    @Test
    public void test_mergeInsert() throws Exception {
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        this.b.prepareUpdate(QueryLanguage.SPARQL, "INSERT { ?painting a <Painting> }\nWHERE { [a <Painter>] <paints> ?painting }", this.NS).execute();
        this.a.commit();
        Assert.assertEquals((long)3L, (long)this.size(this.b, (Resource)this.REMBRANDT, this.PAINTS, null, false, new Resource[0]));
        this.b.commit();
        Assert.assertEquals((long)3L, (long)this.size(this.a, null, RDF.TYPE, (Value)this.PAINTING, false, new Resource[0]));
    }

    @Test
    public void test_changedQuery() throws Exception {
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        List<Value> result = this.eval("painting", this.b, "SELECT ?painting WHERE { [a <Painter>] <paints> ?painting }");
        for (Value painting : result) {
            this.b.add((Resource)painting, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        }
        this.a.commit();
        Assert.assertEquals((long)5L, (long)this.size(this.b, null, this.PAINTS, null, false, new Resource[0]));
        this.b.commit();
        Assert.assertEquals((long)3L, (long)this.size(this.a, null, RDF.TYPE, (Value)this.PAINTING, false, new Resource[0]));
    }

    @Test
    public void test_changedInsert() throws Exception {
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        this.b.prepareUpdate(QueryLanguage.SPARQL, "INSERT { ?painting a <Painting> }\nWHERE { [a <Painter>] <paints> ?painting }", this.NS).execute();
        this.a.commit();
        Assert.assertEquals((long)5L, (long)this.size(this.b, null, this.PAINTS, null, false, new Resource[0]));
        this.b.commit();
        Assert.assertEquals((long)3L, (long)this.size(this.a, null, RDF.TYPE, (Value)this.PAINTING, false, new Resource[0]));
    }

    @Test
    public void test_safeOptionalQuery() throws Exception {
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        List<Value> result = this.eval("painting", this.b, "SELECT ?painting WHERE { ?painter a <Painter> OPTIONAL { ?painter <paints> ?painting } }");
        for (Value painting : result) {
            if (painting == null) continue;
            this.b.add((Resource)painting, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        }
        this.a.commit();
        this.b.commit();
        Assert.assertEquals((long)9L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
        Assert.assertEquals((long)9L, (long)this.size(this.b, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_safeOptionalInsert() throws Exception {
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        this.b.prepareUpdate(QueryLanguage.SPARQL, "INSERT { ?painting a <Painting> }\nWHERE { ?painter a <Painter> OPTIONAL { ?painter <paints> ?painting } }", this.NS).execute();
        this.a.commit();
        this.b.commit();
        Assert.assertEquals((long)9L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
        Assert.assertEquals((long)9L, (long)this.size(this.b, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_mergeOptionalQuery() throws Exception {
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        List<Value> result = this.eval("painting", this.b, "SELECT ?painting WHERE { ?painter a <Painter> OPTIONAL { ?painter <paints> ?painting } }");
        for (Value painting : result) {
            if (painting == null) continue;
            this.b.add((Resource)painting, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        }
        this.a.commit();
        Assert.assertEquals((long)3L, (long)this.size(this.b, (Resource)this.REMBRANDT, this.PAINTS, null, false, new Resource[0]));
        this.b.commit();
        Assert.assertEquals((long)10L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_mergeOptionalInsert() throws Exception {
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        this.b.prepareUpdate(QueryLanguage.SPARQL, "INSERT { ?painting a <Painting> }\nWHERE { ?painter a <Painter> OPTIONAL { ?painter <paints> ?painting } }", this.NS).execute();
        this.a.commit();
        Assert.assertEquals((long)3L, (long)this.size(this.b, (Resource)this.REMBRANDT, this.PAINTS, null, false, new Resource[0]));
        this.b.commit();
        Assert.assertEquals((long)10L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_changedOptionalQuery() throws Exception {
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        List<Value> result = this.eval("painting", this.b, "SELECT ?painting WHERE { ?painter a <Painter> OPTIONAL { ?painter <paints> ?painting } }");
        for (Value painting : result) {
            if (painting == null) continue;
            this.b.add((Resource)painting, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        }
        this.a.commit();
        Assert.assertEquals((long)5L, (long)this.size(this.b, null, this.PAINTS, null, false, new Resource[0]));
        this.b.commit();
        Assert.assertEquals((long)10L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_changedOptionalInsert() throws Exception {
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        this.b.prepareUpdate(QueryLanguage.SPARQL, "INSERT { ?painting a <Painting> }\nWHERE { ?painter a <Painter> OPTIONAL { ?painter <paints> ?painting } }", this.NS).execute();
        this.a.commit();
        Assert.assertEquals((long)5L, (long)this.size(this.b, null, this.PAINTS, null, false, new Resource[0]));
        this.b.commit();
        Assert.assertEquals((long)10L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_safeFilterQuery() throws Exception {
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        List<Value> result = this.eval("painting", this.b, "SELECT ?painting WHERE { ?painter a <Painter>; <paints> ?painting FILTER  regex(str(?painter), \"rem\", \"i\") }");
        for (Value painting : result) {
            this.b.add((Resource)painting, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        }
        this.a.commit();
        this.b.commit();
        Assert.assertEquals((long)10L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_safeFilterInsert() throws Exception {
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        this.b.prepareUpdate(QueryLanguage.SPARQL, "INSERT { ?painting a <Painting> }\nWHERE { ?painter a <Painter>; <paints> ?painting FILTER  regex(str(?painter), \"rem\", \"i\") }", this.NS).execute();
        this.a.commit();
        this.b.commit();
        Assert.assertEquals((long)10L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_mergeOptionalFilterQuery() throws Exception {
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.GUERNICA, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        this.a.add((Resource)this.JACQUELINE, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        List<Value> result = this.eval("painting", this.b, "SELECT ?painting WHERE { [a <Painter>] <paints> ?painting OPTIONAL { ?painting a ?type  } FILTER (!bound(?type)) }");
        Assert.assertEquals((long)5L, (long)result.size());
        for (Value painting : result) {
            if (painting == null) continue;
            this.b.add((Resource)painting, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        }
        this.a.commit();
        Assert.assertEquals((long)5L, (long)this.size(this.b, null, this.PAINTS, null, false, new Resource[0]));
        this.b.commit();
        Assert.assertEquals((long)12L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_mergeOptionalFilterInsert() throws Exception {
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.GUERNICA, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        this.a.add((Resource)this.JACQUELINE, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        this.b.prepareUpdate(QueryLanguage.SPARQL, "INSERT { ?painting a <Painting> }\nWHERE { [a <Painter>] <paints> ?painting OPTIONAL { ?painting a ?type  } FILTER (!bound(?type)) }", this.NS).execute();
        this.a.commit();
        Assert.assertEquals((long)5L, (long)this.size(this.b, null, this.PAINTS, null, false, new Resource[0]));
        this.b.commit();
        Assert.assertEquals((long)12L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_changedOptionalFilterQuery() throws Exception {
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.GUERNICA, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        this.a.add((Resource)this.JACQUELINE, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        List<Value> result = this.eval("painting", this.b, "SELECT ?painting WHERE { [a <Painter>] <paints> ?painting OPTIONAL { ?painting a ?type  } FILTER (!bound(?type)) }");
        for (Value painting : result) {
            if (painting == null) continue;
            this.b.add((Resource)painting, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        }
        this.a.commit();
        Assert.assertEquals((long)7L, (long)this.size(this.b, null, RDF.TYPE, (Value)this.PAINTING, false, new Resource[0]));
        this.b.commit();
        Assert.assertEquals((long)12L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_changedOptionalFilterInsert() throws Exception {
        this.a.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.GUERNICA, new Resource[0]);
        this.a.add((Resource)this.PICASSO, this.PAINTS, (Value)this.JACQUELINE, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.b.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.a.add((Resource)this.GUERNICA, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        this.a.add((Resource)this.JACQUELINE, RDF.TYPE, (Value)this.PAINTING, new Resource[0]);
        this.b.prepareUpdate(QueryLanguage.SPARQL, "INSERT { ?painting a <Painting> }\nWHERE { [a <Painter>] <paints> ?painting OPTIONAL { ?painting a ?type  } FILTER (!bound(?type)) }", this.NS).execute();
        this.a.commit();
        Assert.assertEquals((long)7L, (long)this.size(this.b, null, RDF.TYPE, (Value)this.PAINTING, false, new Resource[0]));
        this.b.commit();
        Assert.assertEquals((long)12L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_safeRangeQuery() throws Exception {
        this.a.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.JACOB, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ANATOMY, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.BELSHAZZAR, new Resource[0]);
        this.a.add((Resource)this.BELSHAZZAR, this.YEAR, (Value)this.lf.createLiteral(1635), new Resource[0]);
        this.a.add((Resource)this.ARTEMISIA, this.YEAR, (Value)this.lf.createLiteral(1634), new Resource[0]);
        this.a.add((Resource)this.DANAE, this.YEAR, (Value)this.lf.createLiteral(1636), new Resource[0]);
        this.a.add((Resource)this.JACOB, this.YEAR, (Value)this.lf.createLiteral(1632), new Resource[0]);
        this.a.add((Resource)this.ANATOMY, this.YEAR, (Value)this.lf.createLiteral(1632), new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        List<Value> result = this.eval("painting", this.b, "SELECT ?painting WHERE { <rembrandt> <paints> ?painting . ?painting <year> ?year FILTER  (1631 <= ?year && ?year <= 1635) }");
        for (Value painting : result) {
            this.b.add((Resource)painting, this.PERIOD, (Value)this.lf.createLiteral("First Amsterdam period"), new Resource[0]);
        }
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.a.add((Resource)this.NIGHTWATCH, this.YEAR, (Value)this.lf.createLiteral(1642), new Resource[0]);
        this.a.commit();
        this.b.commit();
        Assert.assertEquals((long)17L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_safeRangeInsert() throws Exception {
        this.a.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.JACOB, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ANATOMY, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.BELSHAZZAR, new Resource[0]);
        this.a.add((Resource)this.BELSHAZZAR, this.YEAR, (Value)this.lf.createLiteral(1635), new Resource[0]);
        this.a.add((Resource)this.ARTEMISIA, this.YEAR, (Value)this.lf.createLiteral(1634), new Resource[0]);
        this.a.add((Resource)this.DANAE, this.YEAR, (Value)this.lf.createLiteral(1636), new Resource[0]);
        this.a.add((Resource)this.JACOB, this.YEAR, (Value)this.lf.createLiteral(1632), new Resource[0]);
        this.a.add((Resource)this.ANATOMY, this.YEAR, (Value)this.lf.createLiteral(1632), new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.b.prepareUpdate(QueryLanguage.SPARQL, "INSERT { ?painting <period> \"First Amsterdam period\" }\nWHERE { <rembrandt> <paints> ?painting . ?painting <year> ?year FILTER  (1631 <= ?year && ?year <= 1635) }", this.NS).execute();
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.a.add((Resource)this.NIGHTWATCH, this.YEAR, (Value)this.lf.createLiteral(1642), new Resource[0]);
        this.a.commit();
        this.b.commit();
        Assert.assertEquals((long)17L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_mergeRangeQuery() throws Exception {
        this.a.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.JACOB, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ANATOMY, new Resource[0]);
        this.a.add((Resource)this.ARTEMISIA, this.YEAR, (Value)this.lf.createLiteral(1634), new Resource[0]);
        this.a.add((Resource)this.NIGHTWATCH, this.YEAR, (Value)this.lf.createLiteral(1642), new Resource[0]);
        this.a.add((Resource)this.DANAE, this.YEAR, (Value)this.lf.createLiteral(1636), new Resource[0]);
        this.a.add((Resource)this.JACOB, this.YEAR, (Value)this.lf.createLiteral(1632), new Resource[0]);
        this.a.add((Resource)this.ANATOMY, this.YEAR, (Value)this.lf.createLiteral(1632), new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        List<Value> result = this.eval("painting", this.b, "SELECT ?painting WHERE { <rembrandt> <paints> ?painting . ?painting <year> ?year FILTER  (1631 <= ?year && ?year <= 1635) }");
        for (Value painting : result) {
            this.b.add((Resource)painting, this.PERIOD, (Value)this.lf.createLiteral("First Amsterdam period"), new Resource[0]);
        }
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.BELSHAZZAR, new Resource[0]);
        this.a.add((Resource)this.BELSHAZZAR, this.YEAR, (Value)this.lf.createLiteral(1635), new Resource[0]);
        this.a.commit();
        Assert.assertEquals((long)2L, (long)this.size(this.b, (Resource)this.ARTEMISIA, null, null, false, new Resource[0]));
        this.b.commit();
        Assert.assertEquals((long)16L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_mergeRangeInsert() throws Exception {
        this.a.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.JACOB, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ANATOMY, new Resource[0]);
        this.a.add((Resource)this.ARTEMISIA, this.YEAR, (Value)this.lf.createLiteral(1634), new Resource[0]);
        this.a.add((Resource)this.NIGHTWATCH, this.YEAR, (Value)this.lf.createLiteral(1642), new Resource[0]);
        this.a.add((Resource)this.DANAE, this.YEAR, (Value)this.lf.createLiteral(1636), new Resource[0]);
        this.a.add((Resource)this.JACOB, this.YEAR, (Value)this.lf.createLiteral(1632), new Resource[0]);
        this.a.add((Resource)this.ANATOMY, this.YEAR, (Value)this.lf.createLiteral(1632), new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.b.prepareUpdate(QueryLanguage.SPARQL, "INSERT { ?painting <period> \"First Amsterdam period\" }\nWHERE { <rembrandt> <paints> ?painting . ?painting <year> ?year FILTER  (1631 <= ?year && ?year <= 1635) }", this.NS).execute();
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.BELSHAZZAR, new Resource[0]);
        this.a.add((Resource)this.BELSHAZZAR, this.YEAR, (Value)this.lf.createLiteral(1635), new Resource[0]);
        this.a.commit();
        Assert.assertEquals((long)2L, (long)this.size(this.b, (Resource)this.ARTEMISIA, null, null, false, new Resource[0]));
        this.b.commit();
        Assert.assertEquals((long)16L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_changedRangeQuery() throws Exception {
        this.a.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.JACOB, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ANATOMY, new Resource[0]);
        this.a.add((Resource)this.ARTEMISIA, this.YEAR, (Value)this.lf.createLiteral(1634), new Resource[0]);
        this.a.add((Resource)this.NIGHTWATCH, this.YEAR, (Value)this.lf.createLiteral(1642), new Resource[0]);
        this.a.add((Resource)this.DANAE, this.YEAR, (Value)this.lf.createLiteral(1636), new Resource[0]);
        this.a.add((Resource)this.JACOB, this.YEAR, (Value)this.lf.createLiteral(1632), new Resource[0]);
        this.a.add((Resource)this.ANATOMY, this.YEAR, (Value)this.lf.createLiteral(1632), new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        List<Value> result = this.eval("painting", this.b, "SELECT ?painting WHERE { <rembrandt> <paints> ?painting . ?painting <year> ?year FILTER  (1631 <= ?year && ?year <= 1635) }");
        for (Value painting : result) {
            this.b.add((Resource)painting, this.PERIOD, (Value)this.lf.createLiteral("First Amsterdam period"), new Resource[0]);
        }
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.BELSHAZZAR, new Resource[0]);
        this.a.add((Resource)this.BELSHAZZAR, this.YEAR, (Value)this.lf.createLiteral(1635), new Resource[0]);
        this.a.commit();
        Assert.assertEquals((long)6L, (long)this.size(this.b, (Resource)this.REMBRANDT, this.PAINTS, null, false, new Resource[0]));
        this.b.commit();
        Assert.assertEquals((long)16L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
    }

    @Test
    public void test_changedRangeInsert() throws Exception {
        this.a.add((Resource)this.REMBRANDT, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.NIGHTWATCH, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ARTEMISIA, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.DANAE, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.JACOB, new Resource[0]);
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.ANATOMY, new Resource[0]);
        this.a.add((Resource)this.ARTEMISIA, this.YEAR, (Value)this.lf.createLiteral(1634), new Resource[0]);
        this.a.add((Resource)this.NIGHTWATCH, this.YEAR, (Value)this.lf.createLiteral(1642), new Resource[0]);
        this.a.add((Resource)this.DANAE, this.YEAR, (Value)this.lf.createLiteral(1636), new Resource[0]);
        this.a.add((Resource)this.JACOB, this.YEAR, (Value)this.lf.createLiteral(1632), new Resource[0]);
        this.a.add((Resource)this.ANATOMY, this.YEAR, (Value)this.lf.createLiteral(1632), new Resource[0]);
        this.a.begin(this.level);
        this.b.begin(this.level);
        this.b.prepareUpdate(QueryLanguage.SPARQL, "INSERT { ?painting <period> \"First Amsterdam period\" }\nWHERE { <rembrandt> <paints> ?painting . ?painting <year> ?year FILTER  (1631 <= ?year && ?year <= 1635) }", this.NS).execute();
        this.a.add((Resource)this.REMBRANDT, this.PAINTS, (Value)this.BELSHAZZAR, new Resource[0]);
        this.a.add((Resource)this.BELSHAZZAR, this.YEAR, (Value)this.lf.createLiteral(1635), new Resource[0]);
        this.a.commit();
        Assert.assertEquals((long)6L, (long)this.size(this.b, (Resource)this.REMBRANDT, this.PAINTS, null, false, new Resource[0]));
        this.b.commit();
        Assert.assertEquals((long)16L, (long)this.size(this.a, null, null, null, false, new Resource[0]));
    }

    private int size(RepositoryConnection con, Resource subj, IRI pred, Value obj, boolean inf, Resource ... ctx) throws Exception {
        return QueryResults.asList((Iteration)con.getStatements(subj, pred, obj, inf, ctx)).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Value> eval(String var, RepositoryConnection con, String qry) throws Exception {
        try (TupleQueryResult result = con.prepareTupleQuery(QueryLanguage.SPARQL, qry, this.NS).evaluate();){
            ArrayList<Value> list = new ArrayList<Value>();
            while (result.hasNext()) {
                list.add(((BindingSet)result.next()).getValue(var));
            }
            ArrayList<Value> arrayList = list;
            return arrayList;
        }
    }
}

