/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.optimistic;

import java.util.Collections;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.repository.OptimisticIsolationTest;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RemoveIsolationTest {
    private Repository repo;
    private RepositoryConnection con;
    private ValueFactory f;
    private IsolationLevel level = IsolationLevels.SNAPSHOT_READ;

    @Before
    public void setUp() throws Exception {
        this.repo = OptimisticIsolationTest.getEmptyInitializedRepository(RemoveIsolationTest.class);
        this.con = this.repo.getConnection();
        this.f = this.con.getValueFactory();
    }

    @After
    public void tearDown() throws Exception {
        this.con.close();
        this.repo.shutDown();
    }

    @Test
    public void testRemoveOptimisticIsolation() throws Exception {
        this.con.begin(this.level);
        this.con.add((Resource)this.f.createURI("http://example.org/people/alice"), this.f.createURI("http://example.org/ontology/name"), (Value)this.f.createLiteral("Alice"), new Resource[0]);
        this.con.remove((Iteration)this.con.getStatements(null, null, null, true, new Resource[0]), new Resource[0]);
        RepositoryResult stats = this.con.getStatements(null, null, null, true, new Resource[0]);
        Assert.assertEquals(Collections.emptyList(), (Object)QueryResults.asList((Iteration)stats));
        this.con.rollback();
    }

    @Test
    public void testRemoveIsolation() throws Exception {
        this.con.begin(this.level);
        this.con.add((Resource)this.f.createURI("http://example.org/people/alice"), this.f.createURI("http://example.org/ontology/name"), (Value)this.f.createLiteral("Alice"), new Resource[0]);
        this.con.remove((Iteration)this.con.getStatements(null, null, null, true, new Resource[0]), new Resource[0]);
        RepositoryResult stats = this.con.getStatements(null, null, null, true, new Resource[0]);
        Assert.assertEquals(Collections.emptyList(), (Object)QueryResults.asList((Iteration)stats));
        this.con.rollback();
    }
}

