/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.rdf4j.common.io.ResourceUtil;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.inferencer.fc.CustomGraphQueryInferencer;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class CustomGraphQueryInferencerTest {
    private static final String TEST_DIR_PREFIX = "/testcases/custom-query-inferencing/";
    private static final String BASE = "http://foo.org/bar#";
    private static final String PREDICATE = "predicate";
    private String initial;
    private String delete;
    private String resourceFolder;
    private Expectation testData;
    private QueryLanguage language;

    @Parameterized.Parameters(name="{0}")
    public static final Collection<Object[]> parameters() {
        Expectation predExpect = new Expectation(8, 2, 0, 2, 0);
        return Arrays.asList({PREDICATE, predExpect, QueryLanguage.SPARQL}, {"resource", new Expectation(4, 2, 2, 0, 2), QueryLanguage.SPARQL}, {"predicate-serql", predExpect, QueryLanguage.SERQL});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest(CustomGraphQueryInferencer inferencer) throws RepositoryException, RDFParseException, IOException, MalformedQueryException, UpdateExecutionException {
        SailRepository sail = new SailRepository((Sail)inferencer);
        sail.initialize();
        try (RepositoryConnection connection = sail.getConnection();){
            connection.begin();
            connection.clear(new Resource[0]);
            connection.add((Reader)new StringReader(this.initial), BASE, RDFFormat.TURTLE, new Resource[0]);
            Collection watchPredicates = inferencer.getWatchPredicates();
            Assert.assertThat((Object)watchPredicates.size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.testData.predCount)));
            Collection watchObjects = inferencer.getWatchObjects();
            Assert.assertThat((Object)watchObjects.size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.testData.objCount)));
            Collection watchSubjects = inferencer.getWatchSubjects();
            Assert.assertThat((Object)watchSubjects.size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.testData.subjCount)));
            ValueFactory factory = connection.getValueFactory();
            if (this.resourceFolder.startsWith(PREDICATE)) {
                Assert.assertThat((Object)watchPredicates.contains(factory.createIRI(BASE, "brotherOf")), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
                Assert.assertThat((Object)watchPredicates.contains(factory.createIRI(BASE, "parentOf")), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
            } else {
                IRI bob = factory.createIRI(BASE, "Bob");
                IRI alice = factory.createIRI(BASE, "Alice");
                Assert.assertThat((Object)watchSubjects.contains(bob), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
                Assert.assertThat((Object)watchSubjects.contains(alice), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
                Assert.assertThat((Object)watchObjects.contains(bob), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
                Assert.assertThat((Object)watchObjects.contains(alice), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)true)));
            }
            Assert.assertThat((Object)Iterations.asSet((Iteration)connection.getStatements(null, null, null, true, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.testData.initialCount)));
            connection.prepareUpdate(QueryLanguage.SPARQL, this.delete).execute();
            Assert.assertThat((Object)Iterations.asSet((Iteration)connection.getStatements(null, null, null, true, new Resource[0])).size(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)this.testData.countAfterRemove)));
            connection.clear(new Resource[0]);
            connection.commit();
        }
        sail.shutDown();
    }

    public CustomGraphQueryInferencerTest(String resourceFolder, Expectation testData, QueryLanguage language) {
        this.resourceFolder = resourceFolder;
        this.testData = testData;
        this.language = language;
    }

    protected CustomGraphQueryInferencer createRepository(boolean withMatchQuery) throws IOException, MalformedQueryException, UnsupportedQueryLanguageException, RepositoryException, SailException, RDFParseException {
        String testFolder = TEST_DIR_PREFIX + this.resourceFolder;
        String rule = ResourceUtil.getString((String)(testFolder + "/rule.rq"));
        String match = withMatchQuery ? ResourceUtil.getString((String)(testFolder + "/match.rq")) : "";
        this.initial = ResourceUtil.getString((String)(testFolder + "/initial.ttl"));
        this.delete = ResourceUtil.getString((String)(testFolder + "/delete.ru"));
        NotifyingSail store = this.newSail();
        return new CustomGraphQueryInferencer(store, this.language, rule, match);
    }

    protected abstract NotifyingSail newSail();

    @Test
    public void testCustomQueryInference() throws RepositoryException, RDFParseException, MalformedQueryException, UpdateExecutionException, IOException, UnsupportedQueryLanguageException, SailException {
        this.runTest(this.createRepository(true));
    }

    @Test
    public void testCustomQueryInferenceImplicitMatcher() throws RepositoryException, RDFParseException, MalformedQueryException, UpdateExecutionException, IOException, UnsupportedQueryLanguageException, SailException {
        this.runTest(this.createRepository(false));
    }

    protected static class Expectation {
        private final int initialCount;
        private final int countAfterRemove;
        private final int subjCount;
        private final int predCount;
        private final int objCount;

        public Expectation(int initialCount, int countAfterRemove, int subjCount, int predCount, int objCount) {
            this.initialCount = initialCount;
            this.countAfterRemove = countAfterRemove;
            this.subjCount = subjCount;
            this.predCount = predCount;
            this.objCount = objCount;
        }
    }
}

