/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.util.RepositoryUtil;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.junit.Assert;
import org.junit.Test;

public abstract class InferencingTest {
    public static final String TEST_DIR_PREFIX = "/testcases/rdf-mt-inferencing";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(Sail sailStack, String subdir, String testName, boolean isPositiveTest) throws Exception {
        String name = subdir + "/" + testName;
        String inputData = "/testcases/rdf-mt-inferencing/" + name + "-in.nt";
        String outputData = "/testcases/rdf-mt-inferencing/" + name + "-out.nt";
        Collection entailedStatements = null;
        Collection expectedStatements = null;
        SailRepository repository = new SailRepository(sailStack);
        repository.initialize();
        RepositoryConnection con = repository.getConnection();
        con.begin();
        con.clear(new Resource[0]);
        con.commit();
        InputStream stream = this.getClass().getResourceAsStream(inputData);
        try {
            con.begin();
            con.add(stream, inputData, RDFFormat.NTRIPLES, new Resource[0]);
            con.commit();
            entailedStatements = Iterations.addAll((Iteration)con.getStatements(null, null, null, true, new Resource[0]), new HashSet());
        }
        catch (Exception e) {
            if (con.isActive()) {
                con.rollback();
            }
        }
        finally {
            stream.close();
            con.close();
        }
        SailRepository outputRepository = new SailRepository((Sail)new MemoryStore());
        outputRepository.initialize();
        con = outputRepository.getConnection();
        stream = this.getClass().getResourceAsStream(outputData);
        try {
            con.begin();
            con.add(stream, outputData, RDFFormat.NTRIPLES, new Resource[0]);
            con.commit();
            expectedStatements = Iterations.addAll((Iteration)con.getStatements(null, null, null, false, new Resource[0]), new HashSet());
        }
        catch (Exception e) {
            if (con.isActive()) {
                con.rollback();
            }
        }
        finally {
            stream.close();
            con.close();
            outputRepository.shutDown();
            repository.shutDown();
        }
        boolean outputEntailed = Models.isSubset(expectedStatements, (Iterable)entailedStatements);
        if (isPositiveTest && !outputEntailed) {
            File dumpFile = this.dumpStatements(name, RepositoryUtil.difference((Collection)expectedStatements, (Collection)entailedStatements));
            Assert.fail((String)("Incomplete entailment, difference between expected and entailed dumped to file " + dumpFile));
        } else if (!isPositiveTest && outputEntailed) {
            File dumpFile = this.dumpStatements(name, expectedStatements);
            Assert.fail((String)("Erroneous entailment, unexpected statements dumped to file " + dumpFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File dumpStatements(String name, Collection<? extends Statement> statements) throws Exception {
        String tmpDir = System.getProperty("java.io.tmpdir");
        File tmpFile = new File(tmpDir, "junit-" + name + ".nt");
        try (FileOutputStream export = new FileOutputStream(tmpFile);){
            RDFWriter writer = Rio.createWriter((RDFFormat)RDFFormat.NTRIPLES, (OutputStream)export);
            writer.startRDF();
            for (Statement statement : statements) {
                writer.handleStatement(statement);
            }
            writer.endRDF();
        }
        return tmpFile;
    }

    @Test
    public void testSubClassOf001() throws Exception {
        this.runTest(this.createSail(), "subclassof", "test001", true);
    }

    @Test
    public void testSubClassOf002() throws Exception {
        this.runTest(this.createSail(), "subclassof", "test002", true);
    }

    @Test
    public void testSubClassOf003() throws Exception {
        this.runTest(this.createSail(), "subclassof", "test003", true);
    }

    @Test
    public void testSubClassOfError001() throws Exception {
        this.runTest(this.createSail(), "subclassof", "error001", false);
    }

    @Test
    public void testSubPropertyOf001() throws Exception {
        this.runTest(this.createSail(), "subpropertyof", "test001", true);
    }

    @Test
    public void testSubPropertyOf002() throws Exception {
        this.runTest(this.createSail(), "subpropertyof", "test002", true);
    }

    @Test
    public void testSubPropertyOf003() throws Exception {
        this.runTest(this.createSail(), "subpropertyof", "test003", true);
    }

    @Test
    public void testSubPropertyOfError001() throws Exception {
        this.runTest(this.createSail(), "subpropertyof", "error001", false);
    }

    @Test
    public void testDomain001() throws Exception {
        this.runTest(this.createSail(), "domain", "test001", true);
    }

    @Test
    public void testDomainError001() throws Exception {
        this.runTest(this.createSail(), "domain", "error001", false);
    }

    @Test
    public void testRange001() throws Exception {
        this.runTest(this.createSail(), "range", "test001", true);
    }

    @Test
    public void testRangeError001() throws Exception {
        this.runTest(this.createSail(), "range", "error001", false);
    }

    @Test
    public void testType001() throws Exception {
        this.runTest(this.createSail(), "type", "test001", true);
    }

    @Test
    public void testType002() throws Exception {
        this.runTest(this.createSail(), "type", "test002", true);
    }

    @Test
    public void testType003() throws Exception {
        this.runTest(this.createSail(), "type", "test003", true);
    }

    @Test
    public void testType004() throws Exception {
        this.runTest(this.createSail(), "type", "test004", true);
    }

    @Test
    public void testType005() throws Exception {
        this.runTest(this.createSail(), "type", "test005", true);
    }

    @Test
    public void testTypeError001() throws Exception {
        this.runTest(this.createSail(), "type", "error001", false);
    }

    @Test
    public void testTypeError002() throws Exception {
        this.runTest(this.createSail(), "type", "error002", false);
    }

    protected abstract Sail createSail();
}

