/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail;

import java.util.Random;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SailConcurrencyTest {
    private static final int MAX_STATEMENT_IDX = 1000;
    private static final long MAX_TEST_TIME = 30000L;
    private Sail store;
    private ValueFactory vf;
    private boolean m_failed;
    private boolean continueRunning;

    @Before
    public void setUp() throws Exception {
        this.store = this.createSail();
        this.store.initialize();
        this.vf = this.store.getValueFactory();
    }

    protected abstract Sail createSail() throws SailException;

    @After
    public void tearDown() throws Exception {
        this.store.shutDown();
    }

    @Test
    public void testGetContextIDs() throws Exception {
        final Random insertRandomizer = new Random(12345L);
        final Random removeRandomizer = new Random(System.currentTimeMillis());
        Runnable writer = new Runnable(){

            @Override
            public void run() {
                try (SailConnection connection = SailConcurrencyTest.this.store.getConnection();){
                    while (SailConcurrencyTest.this.continueRunning) {
                        connection.begin();
                        for (int i = 0; i < 10; ++i) {
                            SailConcurrencyTest.this.insertTestStatement(connection, insertRandomizer.nextInt() % 1000);
                            SailConcurrencyTest.this.removeTestStatement(connection, removeRandomizer.nextInt() % 1000);
                        }
                        connection.commit();
                    }
                }
                catch (Throwable t) {
                    SailConcurrencyTest.this.continueRunning = false;
                    SailConcurrencyTest.this.fail("Writer failed", t);
                }
            }
        };
        Runnable reader = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (SailConnection connection = SailConcurrencyTest.this.store.getConnection();){
                    while (SailConcurrencyTest.this.continueRunning) {
                        try (CloseableIteration contextIter = connection.getContextIDs();){
                            int contextCount = 0;
                            while (contextIter.hasNext()) {
                                Resource context = (Resource)contextIter.next();
                                Assert.assertNotNull((Object)context);
                                ++contextCount;
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    SailConcurrencyTest.this.continueRunning = false;
                    SailConcurrencyTest.this.fail("Reader failed", t);
                }
            }
        };
        Thread readerThread1 = new Thread(reader);
        Thread readerThread2 = new Thread(reader);
        Thread writerThread1 = new Thread(writer);
        Thread writerThread2 = new Thread(writer);
        System.out.println("Running concurrency test...");
        this.continueRunning = true;
        readerThread1.start();
        readerThread2.start();
        writerThread1.start();
        writerThread2.start();
        readerThread1.join(30000L);
        this.continueRunning = false;
        readerThread1.join(1000L);
        readerThread2.join(1000L);
        writerThread1.join(1000L);
        writerThread2.join(1000L);
        if (this.hasFailed()) {
            Assert.fail((String)"Test Failed");
        } else {
            System.out.println("Test succeeded");
        }
    }

    protected synchronized void fail(String message, Throwable t) {
        System.err.println(message);
        t.printStackTrace();
        this.m_failed = true;
    }

    protected synchronized boolean hasFailed() {
        return this.m_failed;
    }

    protected void insertTestStatement(SailConnection connection, int i) throws SailException {
        connection.addStatement((Resource)this.vf.createIRI("http://test#s" + i), this.vf.createIRI("http://test#p" + i), (Value)this.vf.createIRI("http://test#o" + i), new Resource[]{this.vf.createIRI("http://test#context_" + i)});
    }

    protected void removeTestStatement(SailConnection connection, int i) throws SailException {
        connection.removeStatements((Resource)this.vf.createIRI("http://test#s" + i), this.vf.createIRI("http://test#p" + i), (Value)this.vf.createIRI("http://test#o" + i), new Resource[]{this.vf.createIRI("http://test#context_" + i)});
    }
}

