/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = "";
    String fileName = "";
    String[] fileNames = new String[0];
    String fullPath = "";
    int filterIndex = -1;
    boolean overwrite = false;
    boolean uriMode;
    long handle;
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);
    static final char EXTENSION_SEPARATOR = ';';
    static final char FILE_EXTENSION_SEPARATOR = '.';

    public FileDialog(Shell shell) {
        this(shell, 65536);
    }

    public FileDialog(Shell shell, int n) {
        super(shell, FileDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    String computeResultChooserDialog() {
        long l;
        int n;
        int n2;
        long l2;
        int n3;
        long l3;
        this.fullPath = null;
        if ((this.style & 2) != 0) {
            l3 = 0L;
            l3 = this.uriMode ? OS.gtk_file_chooser_get_uris(this.handle) : OS.gtk_file_chooser_get_filenames(this.handle);
            n3 = OS.g_slist_length(l3);
            this.fileNames = new String[n3];
            l2 = l3;
            n2 = 0;
            for (n = 0; n < n3; ++n) {
                long l4 = OS.g_slist_data(l2);
                long l5 = 0L;
                if (this.uriMode) {
                    l5 = l4;
                } else {
                    l5 = OS.g_filename_to_utf8(l4, -1L, null, null, null);
                    if (l5 == 0L) {
                        l5 = OS.g_filename_display_name(l4);
                    }
                }
                if (l4 != l5) {
                    OS.g_free(l4);
                }
                if (l5 != 0L) {
                    long[] lArray = new long[1];
                    long l6 = OS.g_utf8_to_utf16(l5, -1L, null, lArray, null);
                    OS.g_free(l5);
                    if (l6 != 0L) {
                        int n4 = (int)lArray[0];
                        char[] cArray = new char[n4];
                        OS.memmove(cArray, l6, (long)(n4 * 2));
                        OS.g_free(l6);
                        this.fullPath = new String(cArray);
                        this.fileNames[n2++] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                    }
                }
                l2 = OS.g_slist_next(l2);
            }
            if (n2 != 0 && n2 != n3) {
                String[] stringArray = new String[n2];
                System.arraycopy(this.fileNames, 0, stringArray, 0, n2);
                this.fileNames = stringArray;
            }
            OS.g_slist_free(l3);
        } else {
            l3 = 0L;
            if (this.uriMode) {
                l3 = OS.gtk_file_chooser_get_uri(this.handle);
            } else {
                long l7 = OS.gtk_file_chooser_get_filename(this.handle);
                if (l7 != 0L) {
                    l3 = OS.g_filename_to_utf8(l7, -1L, null, null, null);
                    if (l3 == 0L) {
                        l3 = OS.g_filename_display_name(l7);
                    }
                    if (l7 != l3) {
                        OS.g_free(l7);
                    }
                }
            }
            if (l3 != 0L) {
                long[] lArray = new long[1];
                l2 = OS.g_utf8_to_utf16(l3, -1L, null, lArray, null);
                OS.g_free(l3);
                if (l2 != 0L) {
                    n2 = (int)lArray[0];
                    char[] cArray = new char[n2];
                    OS.memmove(cArray, l2, (long)(n2 * 2));
                    OS.g_free(l2);
                    this.fullPath = new String(cArray);
                    this.fileNames = new String[1];
                    this.fileNames[0] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                }
            }
        }
        this.filterIndex = -1;
        l3 = OS.gtk_file_chooser_get_filter(this.handle);
        if (l3 != 0L && (l = OS.gtk_file_filter_get_name(l3)) != 0L) {
            int n5 = OS.strlen(l);
            byte[] byArray = new byte[n5];
            OS.memmove(byArray, l, (long)n5);
            String string = new String(Converter.mbcsToWcs(null, byArray));
            for (int i = 0; i < this.filterExtensions.length; ++i) {
                if (this.filterNames.length > 0) {
                    if (!this.filterNames[i].equals(string)) continue;
                    this.filterIndex = i;
                    break;
                }
                if (!this.filterExtensions[i].equals(string)) continue;
                this.filterIndex = i;
                break;
            }
        }
        if (this.fullPath != null) {
            n3 = this.fullPath.lastIndexOf(SEPARATOR);
            this.fileName = this.fullPath.substring(n3 + 1);
            this.filterPath = this.fullPath.substring(0, n3);
            int n6 = this.fileName.indexOf(46);
            if ((this.style & 0x2000) != 0 && n6 == -1 && this.filterIndex != -1 && this.filterExtensions.length > this.filterIndex) {
                String string;
                String string2 = this.filterExtensions[this.filterIndex];
                int n7 = string2.length();
                n = string2.indexOf(59);
                if (n == -1) {
                    n = n7;
                }
                if (!(string = string2.substring(0, n).trim()).equals("*") && !string.equals("*.*")) {
                    if (string.startsWith("*.")) {
                        string = string.substring(1);
                    }
                    this.fullPath = this.fullPath + string;
                }
            }
        }
        return this.fullPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        return this.openChooserDialog();
    }

    String openChooserDialog() {
        long l;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        int n = (this.style & 0x2000) != 0 ? 1 : 0;
        long l2 = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.handle = display.getDismissalAlignment() == 131072 ? OS.gtk_file_chooser_dialog_new(byArray, l2, n, OS.GTK_STOCK_CANCEL(), -6, OS.GTK_STOCK_OK(), -5, 0L) : OS.gtk_file_chooser_dialog_new(byArray, l2, n, OS.GTK_STOCK_OK(), -5, OS.GTK_STOCK_CANCEL(), -6, 0L);
        if (this.handle == 0L) {
            this.error(2);
        }
        OS.gtk_window_set_modal(this.handle, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 10, 0)) {
            l = OS.gtk_window_get_group(0L);
            OS.gtk_window_group_add_window(l, this.handle);
        }
        if ((l = OS.gtk_window_get_icon_list(l2)) != 0L) {
            OS.gtk_window_set_icon_list(this.handle, l);
            OS.g_list_free(l);
        }
        if (this.uriMode) {
            OS.gtk_file_chooser_set_local_only(this.handle, false);
        }
        this.presetChooserDialog();
        display.addIdleProc();
        String string = null;
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(this.handle)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n2 = 0;
        long l3 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n2 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            l3 = OS.g_signal_add_emission_hook(n2, 0, display.emissionProc, this.handle, 0L);
        }
        int n3 = OS.gtk_dialog_run(this.handle);
        OS.gdk_threads_leave();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n2, l3);
        }
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setModalDialog(dialog);
        }
        if (n3 == -5) {
            string = this.computeResultChooserDialog();
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(this.handle);
        return string;
    }

    void presetChooserDialog() {
        Object object;
        if ((this.style & 0x2002) == 2) {
            OS.gtk_file_chooser_set_select_multiple(this.handle, true);
        }
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        if (this.fileName == null) {
            this.fileName = "";
        }
        if ((this.style & 0x2000) != 0) {
            if (this.filterPath.length() > 0) {
                if (this.uriMode) {
                    object = Converter.wcsToMbcs(null, this.filterPath, true);
                    OS.gtk_file_chooser_set_current_folder_uri(this.handle, (byte[])object);
                } else {
                    object = Converter.wcsToMbcs(null, SEPARATOR + this.filterPath, true);
                    long l = OS.realpath((byte[])object, null);
                    OS.gtk_file_chooser_set_current_folder(this.handle, l);
                    OS.g_free(l);
                }
            }
            if (this.fileName.length() > 0) {
                object = Converter.wcsToMbcs(null, this.fileName, true);
                OS.gtk_file_chooser_set_current_name(this.handle, (byte[])object);
            }
        } else {
            object = new StringBuffer();
            if (this.filterPath.length() > 0) {
                if (!this.uriMode) {
                    ((StringBuffer)object).append(SEPARATOR);
                }
                ((StringBuffer)object).append(this.filterPath);
                ((StringBuffer)object).append(SEPARATOR);
            }
            if (this.fileName.length() > 0) {
                ((StringBuffer)object).append(this.fileName);
            }
            byte[] byArray = Converter.wcsToMbcs(null, ((StringBuffer)object).toString(), true);
            if (this.uriMode) {
                OS.gtk_file_chooser_set_uri(this.handle, byArray);
            } else {
                long l = OS.realpath(byArray, null);
                if (l != 0L) {
                    if (this.fileName.length() > 0) {
                        OS.gtk_file_chooser_set_filename(this.handle, l);
                    } else {
                        OS.gtk_file_chooser_set_current_folder(this.handle, l);
                    }
                    OS.g_free(l);
                }
            }
        }
        if ((this.style & 0x2000) != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
            OS.gtk_file_chooser_set_do_overwrite_confirmation(this.handle, this.overwrite);
        }
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        long l = 0L;
        for (int i = 0; i < this.filterExtensions.length; ++i) {
            byte[] byArray;
            String string;
            byte[] byArray2;
            if (this.filterExtensions[i] == null) continue;
            long l2 = OS.gtk_file_filter_new();
            if (this.filterNames.length > i && this.filterNames[i] != null) {
                byArray2 = Converter.wcsToMbcs(null, this.filterNames[i], true);
                OS.gtk_file_filter_set_name(l2, byArray2);
            } else {
                byArray2 = Converter.wcsToMbcs(null, this.filterExtensions[i], true);
                OS.gtk_file_filter_set_name(l2, byArray2);
            }
            int n = 0;
            int n2 = this.filterExtensions[i].indexOf(59);
            while (n2 != -1) {
                string = this.filterExtensions[i].substring(n, n2);
                byArray = Converter.wcsToMbcs(null, string, true);
                OS.gtk_file_filter_add_pattern(l2, byArray);
                n = n2 + 1;
                n2 = this.filterExtensions[i].indexOf(59, n);
            }
            string = this.filterExtensions[i].substring(n);
            byArray = Converter.wcsToMbcs(null, string, true);
            OS.gtk_file_filter_add_pattern(l2, byArray);
            OS.gtk_file_chooser_add_filter(this.handle, l2);
            if (i != this.filterIndex) continue;
            l = l2;
        }
        if (l != 0L) {
            OS.gtk_file_chooser_set_filter(this.handle, l);
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterIndex(int n) {
        this.filterIndex = n;
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    void setURIMode(boolean bl) {
        this.uriMode = bl;
    }
}

