/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.publisher;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.updatesite.CategoryXMLAction;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.AbstractPublisherApplication;
import org.eclipse.equinox.p2.publisher.AdviceFileAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.tycho.p2.tools.publisher.PGPSignatureAdvice;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class TychoFeaturesAndBundlesPublisherApplication
extends AbstractPublisherApplication {
    private static final String MAVEN_PREFIX = "maven-";
    private BundleDescription[] bundles;
    private File[] advices;
    private String[] signatures;
    private URI categoryDefinition;
    private String[] rules;
    private String publicKeys;
    private boolean indexArtifacts = true;
    private boolean publishArtifacts = true;

    public Object run(PublisherInfo publisherInfo) throws Exception {
        Object run = super.run(publisherInfo);
        if (run == IApplication.EXIT_OK && this.rules != null && this.artifactLocation != null) {
            String[][] newRules = new String[this.rules.length][];
            int i = 0;
            while (i < this.rules.length) {
                newRules[i] = this.rules[i].split(";", 2);
                ++i;
            }
            SimpleArtifactRepositoryFactory repoFactory = new SimpleArtifactRepositoryFactory();
            SimpleArtifactRepository repo = (SimpleArtifactRepository)repoFactory.load(this.artifactLocation, 1, null);
            repo.setRules(newRules);
            if (this.publicKeys != null) {
                repo.setProperty("pgp.publicKeys", this.publicKeys);
            }
            repo.save();
        }
        return run;
    }

    protected void initialize(PublisherInfo publisherInfo) throws ProvisionException {
        int artifactOptions = 0;
        if (this.indexArtifacts) {
            artifactOptions |= 1;
        }
        if (this.publishArtifacts) {
            artifactOptions |= 2;
        }
        publisherInfo.setArtifactOptions(artifactOptions);
        super.initialize(publisherInfo);
    }

    protected void processParameter(String arg, String parameter, PublisherInfo publisherInfo) throws URISyntaxException {
        super.processParameter(arg, parameter, publisherInfo);
        if (arg.equalsIgnoreCase("-bundles")) {
            this.bundles = (BundleDescription[])Arrays.stream(this.getArrayFromFile(parameter)).map(File::new).map(t -> {
                try {
                    return BundlesAction.createBundleDescription((File)t);
                }
                catch (IOException | BundleException e) {
                    System.out.println("Ignore " + t.getName() + " as it is not a bundle!");
                    return null;
                }
            }).toArray(BundleDescription[]::new);
        }
        if (arg.equalsIgnoreCase("-advices")) {
            this.advices = (File[])Arrays.stream(this.getArrayFromFile(parameter)).map(str -> str.isBlank() ? null : new File((String)str)).toArray(File[]::new);
        }
        if (arg.equalsIgnoreCase("-signatures")) {
            this.signatures = (String[])Arrays.stream(this.getArrayFromFile(parameter)).map(str -> str.isBlank() ? null : new File((String)str)).map(file -> {
                if (file == null) {
                    return null;
                }
                try {
                    return Files.readString(file.toPath(), StandardCharsets.US_ASCII);
                }
                catch (IOException e) {
                    return null;
                }
            }).toArray(String[]::new);
        }
        if (arg.equalsIgnoreCase("-categoryDefinition")) {
            this.categoryDefinition = URIUtil.fromString((String)parameter);
        }
        if (arg.equalsIgnoreCase("-rules")) {
            this.rules = AbstractPublisherAction.getArrayFromString((String)parameter, (String)",");
        }
        if (arg.equalsIgnoreCase("-publicKeys")) {
            try {
                this.publicKeys = Files.readString(Paths.get(parameter, new String[0]), StandardCharsets.US_ASCII);
            }
            catch (IOException e) {
                throw new URISyntaxException(parameter, "can't read public key file: " + e);
            }
        }
        if (arg.equalsIgnoreCase("-aindex")) {
            this.indexArtifacts = Boolean.parseBoolean(parameter);
        }
        if (arg.equalsIgnoreCase("-apublish")) {
            this.publishArtifacts = Boolean.parseBoolean(parameter);
        }
    }

    private String[] getArrayFromFile(String parameter) {
        File file = new File(parameter);
        try {
            return (String[])Files.readAllLines(file.toPath(), StandardCharsets.UTF_8).toArray(String[]::new);
        }
        catch (IOException e) {
            throw new RuntimeException("reading file parameter failed", e);
        }
    }

    protected IPublisherAction[] createActions() {
        String symbolicName;
        BundleDescription bundleDescription;
        int i;
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.advices != null) {
            ArrayList<AdviceFileAdvice> advicesList = new ArrayList<AdviceFileAdvice>();
            i = 0;
            while (i < this.advices.length) {
                File adviceFile = this.advices[i];
                if (i < this.bundles.length && (bundleDescription = this.bundles[i]) != null && (symbolicName = bundleDescription.getSymbolicName()) != null) {
                    advicesList.add(new AdviceFileAdvice(symbolicName, PublisherHelper.fromOSGiVersion((Version)bundleDescription.getVersion()), (IPath)new Path(adviceFile.getParentFile().getAbsolutePath()), (IPath)new Path(adviceFile.getName())){

                        public Map<String, String> getArtifactProperties(IInstallableUnit iu, IArtifactDescriptor descriptor) {
                            Map properties = super.getInstallableUnitProperties(null);
                            if (properties != null && descriptor instanceof ArtifactDescriptor) {
                                ArtifactDescriptor artifactDescriptor = (ArtifactDescriptor)descriptor;
                                for (Map.Entry entry : properties.entrySet()) {
                                    String key = (String)entry.getKey();
                                    String value = (String)entry.getValue();
                                    if (!key.startsWith(TychoFeaturesAndBundlesPublisherApplication.MAVEN_PREFIX)) continue;
                                    String key2 = "maven." + key.substring(TychoFeaturesAndBundlesPublisherApplication.MAVEN_PREFIX.length());
                                    artifactDescriptor.setProperty(key2, value);
                                }
                            }
                            return null;
                        }

                        public Map<String, String> getInstallableUnitProperties(MetadataFactory.InstallableUnitDescription iu) {
                            Map properties = super.getInstallableUnitProperties(iu);
                            if (properties == null) {
                                return null;
                            }
                            LinkedHashMap<String, String> installableUnitProperties = new LinkedHashMap<String, String>(properties);
                            Set keySet = installableUnitProperties.keySet();
                            Iterator iterator = keySet.iterator();
                            while (iterator.hasNext()) {
                                String string = (String)iterator.next();
                                if (!string.startsWith(TychoFeaturesAndBundlesPublisherApplication.MAVEN_PREFIX)) continue;
                                iterator.remove();
                            }
                            return installableUnitProperties.isEmpty() ? null : installableUnitProperties;
                        }
                    });
                    result.add((Object)new AdviceFilePublisherAction(advicesList));
                }
                ++i;
            }
        }
        if (this.signatures != null) {
            ArrayList<PGPSignatureAdvice> signaturesList = new ArrayList<PGPSignatureAdvice>();
            i = 0;
            while (i < this.signatures.length) {
                String signature = this.signatures[i];
                if (signature != null && i < this.bundles.length && (bundleDescription = this.bundles[i]) != null && (symbolicName = bundleDescription.getSymbolicName()) != null) {
                    signaturesList.add(new PGPSignatureAdvice(symbolicName, PublisherHelper.fromOSGiVersion((Version)bundleDescription.getVersion()), signature, this.publicKeys));
                }
                ++i;
            }
            result.add((Object)new SignaturePublisherAction(signaturesList));
        }
        if (this.bundles != null) {
            result.add(new BundlesAction(this.bundles));
        }
        if (this.categoryDefinition != null) {
            result.add(new CategoryXMLAction(this.categoryDefinition, "category"));
        }
        return (IPublisherAction[])result.toArray(IPublisherAction[]::new);
    }

    private static final class AdviceFilePublisherAction
    extends AbstractPublisherAction {
        private List<AdviceFileAdvice> advicesList;

        public AdviceFilePublisherAction(List<AdviceFileAdvice> advicesList) {
            this.advicesList = advicesList;
        }

        public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
            for (AdviceFileAdvice advice : this.advicesList) {
                publisherInfo.addAdvice((IPublisherAdvice)advice);
            }
            return Status.OK_STATUS;
        }
    }

    private static final class SignaturePublisherAction
    extends AbstractPublisherAction {
        private List<PGPSignatureAdvice> signaturesList;

        public SignaturePublisherAction(List<PGPSignatureAdvice> signaturesList) {
            this.signaturesList = signaturesList;
        }

        public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
            for (PGPSignatureAdvice signature : this.signaturesList) {
                publisherInfo.addAdvice((IPublisherAdvice)signature);
            }
            return Status.OK_STATUS;
        }
    }
}

