/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.filter;

import java.util.Optional;
import java.util.function.BiConsumer;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;

@API(status=API.Status.INTERNAL, since="1.0")
public class ExclusionReasonConsumingFilter<T>
implements Filter<T> {
    private final Filter<T> filter;
    private final BiConsumer<T, Optional<String>> reasonConsumer;

    public ExclusionReasonConsumingFilter(Filter<T> filter, BiConsumer<T, Optional<String>> reasonConsumer) {
        this.filter = Preconditions.notNull(filter, "filter must not be null");
        this.reasonConsumer = Preconditions.notNull(reasonConsumer, "reasonConsumer must not be null");
    }

    @Override
    public FilterResult apply(T object) {
        FilterResult result = this.filter.apply(object);
        if (result.excluded()) {
            this.reasonConsumer.accept(object, result.getReason());
        }
        return result;
    }
}

