/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.local.testutil;

import java.io.File;
import java.io.IOException;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MockMavenContext;
import org.eclipse.tycho.locking.facade.FileLockService;
import org.eclipse.tycho.p2.repository.LocalRepositoryP2Indices;
import org.eclipse.tycho.repository.local.LocalArtifactRepository;
import org.eclipse.tycho.repository.local.index.LocalRepositoryP2IndicesImpl;
import org.eclipse.tycho.test.util.LogVerifier;
import org.eclipse.tycho.test.util.NoopFileLockService;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;

public class TemporaryLocalMavenRepository
extends ExternalResource {
    public LogVerifier logVerifier = new LogVerifier();
    private final TemporaryFolder tempManager = new TemporaryFolder();
    private File repoRoot;
    private LocalRepositoryP2Indices repoIndex;
    private LocalArtifactRepository repo;

    protected void before() throws Throwable {
        this.tempManager.create();
    }

    protected void after() {
        this.tempManager.delete();
    }

    public void initContentFromResourceFolder(File resourceFolder) throws IOException {
        FileUtils.copy((File)resourceFolder, (File)this.getLocalRepositoryRoot(), (File)new File("."), (boolean)true);
    }

    public File getLocalRepositoryRoot() {
        if (this.repoRoot == null) {
            try {
                this.repoRoot = this.tempManager.newFolder("repository");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.repoRoot;
    }

    public LocalRepositoryP2Indices getLocalRepositoryIndex() {
        if (this.repoIndex == null) {
            this.createLocalRepoIndices();
        }
        return this.repoIndex;
    }

    private void createLocalRepoIndices() {
        this.repoIndex = new LocalRepositoryP2IndicesImpl((MavenContext)new MockMavenContext(this.getLocalRepositoryRoot(), this.logVerifier.getLogger()), (FileLockService)new NoopFileLockService());
    }

    public LocalArtifactRepository getLocalArtifactRepository() {
        if (this.repo == null) {
            this.repo = new LocalArtifactRepository(null, this.getLocalRepositoryIndex());
        }
        return this.repo;
    }
}

