/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.streaming.testutil;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.repository.IStateful;
import org.eclipse.tycho.repository.streaming.testutil.NoopOutputStream;

public class ProbeOutputStream
extends OutputStream
implements IStateful {
    static String MD5_SUM_ZEROS = "00000000000000000000000000000000";
    private ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
    private boolean byteBufferIsClosed = false;
    private IStatus externallySetStatus = Status.OK_STATUS;

    public int writtenBytes() {
        return this.byteBuffer.size();
    }

    public boolean isClosed() {
        return this.byteBufferIsClosed;
    }

    public Set<String> getFilesInZip() throws IOException {
        HashSet<String> result = new HashSet<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipInputStream zipStream = new ZipInputStream(new ByteArrayInputStream(this.byteBuffer.toByteArray()));){
            ZipEntry entry = zipStream.getNextEntry();
            while (entry != null) {
                result.add(entry.getName());
                entry = zipStream.getNextEntry();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    public String md5AsHex() throws IOException {
        DigestOutputStream digestStream = this.createMd5DigestStream();
        this.writeBufferedContent(digestStream);
        return this.formatDigestAsPaddedHex(digestStream, MD5_SUM_ZEROS);
    }

    private DigestOutputStream createMd5DigestStream() {
        try {
            return new DigestOutputStream(new NoopOutputStream(), MessageDigest.getInstance("MD5"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeBufferedContent(DigestOutputStream digestStream) throws IOException {
        byte[] content = this.byteBuffer.toByteArray();
        digestStream.write(content, 0, content.length);
    }

    private String formatDigestAsPaddedHex(DigestOutputStream digestStream, String padding) {
        byte[] digest = digestStream.getMessageDigest().digest();
        String digestHex = new BigInteger(1, digest).toString(16);
        String paddedDigestHex = String.valueOf(padding.substring(0, padding.length() - digestHex.length())) + digestHex;
        return paddedDigestHex;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.byteBuffer.write(b);
    }

    @Override
    public void write(int b) throws IOException {
        this.byteBuffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.byteBuffer.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.byteBuffer.flush();
    }

    @Override
    public void close() throws IOException {
        this.byteBufferIsClosed = true;
        this.byteBuffer.close();
    }

    public void setStatus(IStatus status) {
        this.externallySetStatus = status;
    }

    public IStatus getStatus() {
        return this.externallySetStatus;
    }
}

