/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.testutil;

import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ArtifactPropertiesMatchers {
    public static Matcher<Map<String, String>> containsGAV(String groupId, String artifactId, String version) {
        return ArtifactPropertiesMatchers.containsGAV(groupId, artifactId, version, null);
    }

    public static Matcher<Map<String, String>> containsGAV(final String groupId, final String artifactId, final String version, final String classifier) {
        return new TypeSafeMatcher<Map<String, String>>(){

            public void describeTo(Description description) {
                description.appendText("properties specifying the GAV " + ArtifactPropertiesMatchers.gavString(groupId, artifactId, version, classifier));
            }

            public boolean matchesSafely(Map<String, String> map) {
                String actualGroupId = map.get("maven-groupId");
                String actualArtifactId = map.get("maven-artifactId");
                String actualVersion = map.get("maven-version");
                String actualClassifier = map.get("maven-classifier");
                return ArtifactPropertiesMatchers.isEqual(groupId, actualGroupId) && ArtifactPropertiesMatchers.isEqual(artifactId, actualArtifactId) && ArtifactPropertiesMatchers.isEqual(version, actualVersion) && ArtifactPropertiesMatchers.isEqual(classifier, actualClassifier);
            }
        };
    }

    public static Matcher<Map<String, String>> hasProperty(final String key, final String value) {
        return new TypeSafeMatcher<Map<String, String>>(){

            public void describeTo(Description description) {
                description.appendText("properties with the entry ").appendValue((Object)key).appendText("=").appendValue((Object)value);
            }

            protected boolean matchesSafely(Map<String, String> map) {
                return map.containsKey(key) && ArtifactPropertiesMatchers.isEqual(value, map.get(key));
            }
        };
    }

    static String gavString(String groupId, String artifactId, String version, String classifier) {
        return String.valueOf(groupId) + ":" + artifactId + ":" + version + (classifier == null ? "" : ":" + classifier);
    }

    static <T> boolean isEqual(T left, T right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }
}

