/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.testutil;

import java.util.Set;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.tycho.repository.p2base.artifact.provider.formats.ArtifactTransferPolicy;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ArtifactRepositoryTestUtils {
    public static final IQuery<IArtifactKey> ANY_ARTIFACT_KEY_QUERY = QueryUtil.createMatchQuery(IArtifactKey.class, (String)"true", (Object[])new Object[0]);

    public static Set<IArtifactKey> allKeysIn(IArtifactRepository repository) {
        IQueryResult queryResult = repository.query(ANY_ARTIFACT_KEY_QUERY, null);
        return queryResult.toUnmodifiableSet();
    }

    public static IArtifactDescriptor canonicalDescriptorFor(IArtifactKey key) {
        return new ArtifactDescriptor(key);
    }

    public static Matcher<? super IArtifactDescriptor> inCanonicalFormat() {
        return new TypeSafeMatcher<IArtifactDescriptor>(){

            public void describeTo(Description description) {
                description.appendText("a canonical artifact");
            }

            public boolean matchesSafely(IArtifactDescriptor item) {
                return ArtifactTransferPolicy.isCanonicalFormat((IArtifactDescriptor)item);
            }
        };
    }
}

