/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.tycho.test.util.AbstractMonitorServlet;

public class FileServerServlet
extends AbstractMonitorServlet {
    private static final long serialVersionUID = -6702619558275132007L;
    private File content;

    public FileServerServlet(File content) {
        this.content = content;
    }

    @Override
    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        File file = new File(this.content, path);
        if (!file.exists()) {
            res.sendError(404, "File not found " + file.getAbsolutePath());
            return;
        }
        if (!file.isFile()) {
            res.sendError(403, "Directory not accessible " + file.getAbsolutePath());
            return;
        }
        this.addUri(req);
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileInputStream input = new FileInputStream(file);
             ServletOutputStream output = res.getOutputStream();){
            byte[] buffer = new byte[10240];
            int n = 0;
            while (-1 != (n = ((InputStream)input).read(buffer))) {
                output.write(buffer, 0, n);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

