/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.io.File;
import java.net.BindException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.tycho.test.util.FileServerServlet;
import org.junit.rules.ExternalResource;

public class HttpServer
extends ExternalResource {
    static final int BIND_ATTEMPTS = 20;
    static final Random rnd = new Random();
    private RunningServer runningServer;

    protected void before() throws Throwable {
        this.runningServer = HttpServer.startServer();
    }

    protected void after() {
        try {
            this.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static RunningServer startServer() throws Exception {
        int baseport = 1024;
        BindException cause = null;
        int i = 0;
        while (i < 20) {
            int port = baseport + rnd.nextInt(65534 - baseport);
            try {
                return HttpServer.startServerOnPort(port);
            }
            catch (BindException e) {
                cause = e;
                ++i;
            }
        }
        throw new IllegalStateException("Could not allocate available port", cause);
    }

    private static RunningServer startServerOnPort(int port) throws Exception {
        Server jetty = new Server();
        ServerConnector connector = new ServerConnector(jetty);
        connector.setHost("localhost");
        connector.setPort(port);
        jetty.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)jetty, "/", 0);
        jetty.start();
        return new RunningServer(port, jetty, context);
    }

    public String addServlet(String contextName, File content) {
        this.checkRunning();
        FileServerServlet servlet = new FileServerServlet(content);
        this.runningServer.servlets.put(contextName, servlet);
        this.runningServer.context.addServlet(new ServletHolder((Servlet)servlet), "/" + contextName + "/*");
        return this.getUrl(contextName);
    }

    public String getUrl(String contextName) {
        this.checkRunning();
        return "http://localhost:" + this.runningServer.port + "/" + contextName;
    }

    public List<String> getAccessedUrls(String contextName) {
        this.checkRunning();
        return this.runningServer.servlets.get(contextName).getAccessedUrls();
    }

    public void clearAccessedUrls(String contextName) {
        this.checkRunning();
        this.runningServer.servlets.get(contextName).getAccessedUrls().clear();
    }

    public void stop() throws Exception {
        if (this.runningServer != null) {
            this.runningServer.server.stop();
            this.runningServer.server.join();
        }
        this.runningServer = null;
    }

    private void checkRunning() {
        if (this.runningServer == null) {
            throw new IllegalStateException("HttpServer instance is not running. Did you forget the @Rule annotation?");
        }
    }

    private static class RunningServer {
        final Server server;
        final ServletContextHandler context;
        final int port;
        final Map<String, FileServerServlet> servlets = new HashMap<String, FileServerServlet>();

        RunningServer(int port, Server jettyIntance, ServletContextHandler context) {
            this.port = port;
            this.server = jettyIntance;
            this.context = context;
        }
    }
}

