/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.rules.Verifier;

public class LogVerifier
extends Verifier {
    private static boolean WRITE_TO_CONSOLE = false;
    private TestRunContext currentContext;

    private TestRunContext getInitializedContext() {
        if (this.currentContext == null) {
            this.currentContext = new TestRunContext();
        }
        return this.currentContext;
    }

    public MavenLogger getLogger() {
        return this.getInitializedContext().getInitializedLogger();
    }

    public void expectError(String string) {
        this.expectError((Matcher<String>)CoreMatchers.containsString((String)string));
    }

    public void expectError(Matcher<String> matcher) {
        TestRunContext context = this.getInitializedContext();
        context.expectNoErrors = false;
        context.loggedErrorsMatchers.add(matcher);
    }

    public void expectWarning(String string) {
        this.expectWarning((Matcher<String>)CoreMatchers.containsString((String)string));
    }

    public void expectWarning(Matcher<String> matcher) {
        TestRunContext context = this.getInitializedContext();
        context.expectNoWarnings = false;
        context.loggedWarningsMatchers.add(matcher);
    }

    public void expectNoWarnings() {
        this.getInitializedContext().expectNoWarnings = true;
    }

    public void expectInfo(String string) {
        this.expectInfo((Matcher<String>)CoreMatchers.containsString((String)string));
    }

    public void expectInfo(Matcher<String> matcher) {
        TestRunContext context = this.getInitializedContext();
        context.loggedInfosMatchers.add(matcher);
    }

    protected void verify() throws Throwable {
        TestRunContext contextAfterTest = this.currentContext;
        this.currentContext = null;
        if (contextAfterTest != null) {
            contextAfterTest.checkLoggedErrors();
            contextAfterTest.checkLoggedWarnings();
            contextAfterTest.checkLoggedInfos();
        }
    }

    private class MemoryLog
    implements MavenLogger {
        final StringBuilder errors = new StringBuilder();
        final StringBuilder warnings = new StringBuilder();
        final StringBuilder infos = new StringBuilder();

        private MemoryLog() {
        }

        public void error(String message) {
            this.errors.append(message);
            this.errors.append('\n');
            if (WRITE_TO_CONSOLE) {
                System.out.println("[ERROR] " + message);
            }
        }

        public void error(String message, Throwable cause) {
            this.error(message);
        }

        public void warn(String message) {
            this.warnings.append(message);
            this.warnings.append('\n');
            if (WRITE_TO_CONSOLE) {
                System.out.println("[WARNING] " + message);
            }
        }

        public void warn(String message, Throwable cause) {
            this.warn(message);
        }

        public void debug(String message, Throwable cause) {
            this.debug(message);
        }

        public void info(String message) {
            this.infos.append(message);
            this.infos.append('\n');
            if (WRITE_TO_CONSOLE) {
                System.out.println("[INFO] " + message);
            }
        }

        public void debug(String message) {
            if (WRITE_TO_CONSOLE) {
                System.out.println("[DEBUG] " + message);
            }
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public boolean isExtendedDebugEnabled() {
            return true;
        }
    }

    private class TestRunContext {
        MemoryLog logger;
        boolean expectNoErrors = true;
        List<Matcher<? super String>> loggedErrorsMatchers = new ArrayList<Matcher<? super String>>();
        boolean expectNoWarnings = false;
        List<Matcher<? super String>> loggedWarningsMatchers = new ArrayList<Matcher<? super String>>();
        List<Matcher<? super String>> loggedInfosMatchers = new ArrayList<Matcher<? super String>>();

        private TestRunContext() {
        }

        MemoryLog getInitializedLogger() {
            if (this.logger == null) {
                this.logger = new MemoryLog();
            }
            return this.logger;
        }

        void checkLoggedErrors() {
            if (this.expectNoErrors) {
                Assert.assertEquals((Object)"", (Object)this.getLoggedErrors());
            } else {
                Matcher combinedMatcher = CoreMatchers.allOf(this.loggedErrorsMatchers);
                MatcherAssert.assertThat((Object)this.getLoggedErrors(), (Matcher)combinedMatcher);
            }
        }

        void checkLoggedWarnings() {
            if (this.expectNoWarnings) {
                Assert.assertEquals((Object)"", (Object)this.getLoggedWarnings());
            } else {
                Matcher combinedMatcher = CoreMatchers.allOf(this.loggedWarningsMatchers);
                MatcherAssert.assertThat((Object)this.getLoggedWarnings(), (Matcher)combinedMatcher);
            }
        }

        void checkLoggedInfos() {
            Matcher combinedMatcher = CoreMatchers.allOf(this.loggedInfosMatchers);
            MatcherAssert.assertThat((Object)this.getLoggedInfos(), (Matcher)combinedMatcher);
        }

        private String getLoggedErrors() {
            if (this.logger == null) {
                return "";
            }
            return this.logger.errors.toString();
        }

        private String getLoggedWarnings() {
            if (this.logger == null) {
                return "";
            }
            return this.logger.warnings.toString();
        }

        private String getLoggedInfos() {
            if (this.logger == null) {
                return "";
            }
            return this.logger.infos.toString();
        }
    }
}

