/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class TychoMatchers {
    public static <T> Matcher<List<T>> hasSequence(final T ... sequence) {
        if (sequence.length == 0) {
            throw new IllegalArgumentException();
        }
        return new TypeSafeMatcher<List<T>>(){

            public void describeTo(Description description) {
                description.appendValueList("a list with the sequence ", ", ", "", sequence);
            }

            public boolean matchesSafely(List<T> actualList) {
                int actualListIx = 0;
                while (actualListIx <= actualList.size() - sequence.length) {
                    if (this.sequenceMatches(actualList, actualListIx, sequence)) {
                        return true;
                    }
                    ++actualListIx;
                }
                return false;
            }

            private boolean sequenceMatches(List<T> actualList, int actualListIx, T[] sequence2) {
                int sequenceIx = 0;
                while (sequenceIx < sequence2.length) {
                    if (!sequence2[sequenceIx].equals(actualList.get(actualListIx + sequenceIx))) {
                        return false;
                    }
                    ++sequenceIx;
                }
                return true;
            }
        };
    }
}

