/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.remote.testutil;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.tycho.IRepositoryIdManager;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.MavenRepositorySettings;

public class NoopRepositoryIdManager
implements IRepositoryIdManager {
    private IProvisioningAgent agent;
    private Map<URI, String> knownMavenRepositoryIds = new ConcurrentHashMap<URI, String>();

    public NoopRepositoryIdManager(IProvisioningAgent agent) {
        this.agent = agent;
    }

    public void addMapping(String mavenRepositoryId, URI location) {
        if (mavenRepositoryId == null) {
            return;
        }
        URI key = NoopRepositoryIdManager.normalize(location);
        this.knownMavenRepositoryIds.put(key, mavenRepositoryId);
    }

    private static URI normalize(URI location) {
        try {
            String path = location.getPath();
            if (path != null && path.endsWith("/")) {
                return new URI(location.getScheme(), location.getAuthority(), path.substring(0, path.length() - 1), location.getQuery(), location.getFragment());
            }
            return location;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URI getEffectiveLocation(URI location) {
        if (NoopRepositoryIdManager.certainlyNoRemoteURL(location)) {
            return location;
        }
        MavenRepositoryLocation effectiveLocation = this.effectiveLocationFor(location, false);
        return effectiveLocation.getURL();
    }

    public URI getEffectiveLocationAndPrepareLoad(URI location) {
        if (NoopRepositoryIdManager.certainlyNoRemoteURL(location)) {
            return location;
        }
        MavenRepositoryLocation effectiveLocation = this.effectiveLocationFor(location, true);
        return effectiveLocation.getURL();
    }

    private MavenRepositoryLocation effectiveLocationFor(URI location, boolean forLoading) {
        URI normalizedLocation = NoopRepositoryIdManager.normalize(location);
        String id = this.knownMavenRepositoryIds.get(normalizedLocation);
        if (id == null) {
            id = normalizedLocation.toString();
        }
        MavenRepositoryLocation locationWithID = new MavenRepositoryLocation(id, normalizedLocation);
        MavenRepositorySettings service = (MavenRepositorySettings)this.agent.getService(MavenRepositorySettings.class);
        MavenRepositoryLocation mirror = service.getMirror(locationWithID);
        if (mirror != null) {
            return mirror;
        }
        return locationWithID;
    }

    private static boolean certainlyNoRemoteURL(URI location) {
        return location.isOpaque() || !location.isAbsolute();
    }

    public Stream<MavenRepositoryLocation> getKnownMavenRepositoryLocations() {
        return this.knownMavenRepositoryIds.entrySet().stream().map(e -> new MavenRepositoryLocation((String)e.getValue(), (URI)e.getKey()));
    }
}

