/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.testutil;

import java.util.Map;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.tycho.p2.testutil.InstallableUnitUtil;
import org.eclipse.tycho.repository.testutil.ArtifactPropertiesMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

public class InstallableUnitMatchers {
    private static final String TYPE = "IInstallableUnit";

    public static Matcher<IInstallableUnit> unitWithId(final String id) {
        return new TypeSafeMatcher<IInstallableUnit>(IInstallableUnit.class){

            public void describeTo(Description description) {
                description.appendText("IInstallableUnit with ID " + id);
            }

            public boolean matchesSafely(IInstallableUnit item) {
                return id.equals(item.getId());
            }
        };
    }

    public static Matcher<IInstallableUnit> unit(final String id, String version) {
        final Version parsedVersion = Version.parseVersion((String)version);
        return new TypeSafeMatcher<IInstallableUnit>(){

            public void describeTo(Description description) {
                description.appendText("IInstallableUnit with with ID " + id + " and version " + parsedVersion);
            }

            public boolean matchesSafely(IInstallableUnit item) {
                return id.equals(item.getId()) && parsedVersion.equals(item.getVersion());
            }
        };
    }

    public static Matcher<IInstallableUnit> unitWithIdAndVersion(IVersionedId versionedId) {
        return InstallableUnitMatchers.unit(versionedId.getId(), versionedId.getVersion().toString());
    }

    public static Matcher<IInstallableUnit> productUnit() {
        return new TypeSafeMatcher<IInstallableUnit>(){

            public void describeTo(Description description) {
                description.appendText("a product installable unit");
            }

            protected boolean matchesSafely(IInstallableUnit item) {
                return Boolean.valueOf(item.getProperty("org.eclipse.equinox.p2.type.product"));
            }
        };
    }

    public static Matcher<IInstallableUnit> hasGAV(String groupId, String artifactId, String version) {
        return InstallableUnitMatchers.hasGAV(groupId, artifactId, version, null);
    }

    public static Matcher<IInstallableUnit> hasGAV(String groupId, String artifactId, String version, String classifier) {
        final Matcher<Map<String, String>> propertiesMatcher = ArtifactPropertiesMatchers.containsGAV(groupId, artifactId, version, classifier);
        return new TypeSafeMatcher<IInstallableUnit>(){

            public void describeTo(Description description) {
                description.appendText(InstallableUnitMatchers.TYPE).appendText(" with ").appendDescriptionOf((SelfDescribing)propertiesMatcher);
            }

            public boolean matchesSafely(IInstallableUnit item) {
                return propertiesMatcher.matches((Object)item.getProperties());
            }
        };
    }

    public static Matcher<IInstallableUnit> hasSelfCapability() {
        return new TypeSafeMatcher<IInstallableUnit>(){

            public void describeTo(Description description) {
                description.appendText("an installable unit providing the self-capability");
            }

            protected boolean matchesSafely(IInstallableUnit unit) {
                String name = unit.getId();
                Version version = unit.getVersion();
                for (IProvidedCapability capability : unit.getProvidedCapabilities()) {
                    if (!"org.eclipse.equinox.p2.iu".equals(capability.getNamespace()) || !name.equals(capability.getName()) || !version.equals(capability.getVersion())) continue;
                    return true;
                }
                return false;
            }

            protected void describeMismatchSafely(IInstallableUnit item, Description mismatchDescription) {
                mismatchDescription.appendValue((Object)item).appendText(" has the provided capabilities ").appendValue((Object)item.getProvidedCapabilities());
            }
        };
    }

    public static Matcher<IProvidedCapability> packageCapability(final String packageName) {
        return new TypeSafeMatcher<IProvidedCapability>(){

            protected boolean matchesSafely(IProvidedCapability item) {
                return "java.package".equals(item.getNamespace()) && packageName.equals(item.getName());
            }

            public void describeTo(Description description) {
                description.appendText("the capability java.package/" + packageName);
            }
        };
    }

    public static Matcher<IProvidedCapability> eeCapability(final String eeName, String eeVersion) {
        final Version parsedVersion = Version.parseVersion((String)eeVersion);
        return new TypeSafeMatcher<IProvidedCapability>(){

            protected boolean matchesSafely(IProvidedCapability item) {
                return "osgi.ee".equals(item.getNamespace()) && eeName.equals(item.getName()) && parsedVersion.equals(item.getVersion());
            }

            public void describeTo(Description description) {
                description.appendText("the capability osgi.ee/" + eeName + "/" + parsedVersion);
            }
        };
    }

    public static Matcher<? super IRequirement> requirement(final String id, final String version) {
        final IInstallableUnit unit = InstallableUnitUtil.createIU(id, version);
        return new TypeSafeMatcher<IRequirement>(){

            public void describeTo(Description description) {
                description.appendText("a require of unit ").appendText(id).appendText(":").appendText(version);
            }

            protected boolean matchesSafely(IRequirement item) {
                return item.isMatch(unit);
            }
        };
    }

    public static Matcher<IRequirement> strictRequirement(final String id, final String version) {
        final IRequirement requirement = InstallableUnitUtil.createStrictRequirement(id, version);
        return new TypeSafeMatcher<IRequirement>(){

            public void describeTo(Description description) {
                description.appendText("a strict require of unit ").appendText(id).appendText(":").appendText(version);
            }

            protected boolean matchesSafely(IRequirement item) {
                return requirement.equals(item);
            }
        };
    }

    public static Matcher<? super ITouchpointData> configureTouchpointInstructionThat(final Matcher<String> instructionMatcher) {
        return new TypeSafeMatcher<ITouchpointData>(){

            public void describeTo(Description description) {
                description.appendText("a 'configure' touchpoint with: ").appendDescriptionOf((SelfDescribing)instructionMatcher);
            }

            protected boolean matchesSafely(ITouchpointData item) {
                return instructionMatcher.matches((Object)item.getInstruction("configure").getBody());
            }
        };
    }
}

