/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.testutil;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;

public class InstallableUnitUtil {
    static final String IU_CAPABILITY_NS = "org.eclipse.equinox.p2.iu";
    static final String BUNDLE_CAPABILITY_NS = "osgi.bundle";
    static final String PRODUCT_TYPE_PROPERTY = "org.eclipse.equinox.p2.type.product";
    static final String FEATURE_TYPE_PROPERTY = "org.eclipse.equinox.p2.type.group";
    public static String DEFAULT_VERSION = "0.0.20";

    public static IInstallableUnit createIU(String versionedId) {
        int separator = versionedId.indexOf(47);
        if (separator > 0) {
            return InstallableUnitUtil.createIU(versionedId.substring(0, separator), versionedId.substring(separator + 1));
        }
        return InstallableUnitUtil.createIU(versionedId, DEFAULT_VERSION);
    }

    public static IInstallableUnit createIU(String id, String version) {
        MetadataFactory.InstallableUnitDescription description = InstallableUnitUtil.createIuDescription(id, version);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
    }

    public static IInstallableUnit createBundleIU(String bundleId, String version) {
        MetadataFactory.InstallableUnitDescription description = InstallableUnitUtil.createIuDescription(bundleId, version);
        description.addProvidedCapabilities(InstallableUnitUtil.createProvidedCapability(BUNDLE_CAPABILITY_NS, bundleId, version));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
    }

    public static IInstallableUnit createProductIU(String productId, String version) {
        MetadataFactory.InstallableUnitDescription description = InstallableUnitUtil.createIuDescription(productId, version);
        description.setProperty(PRODUCT_TYPE_PROPERTY, Boolean.toString(true));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
    }

    public static IInstallableUnit createFeatureIU(String featureId, String version) {
        MetadataFactory.InstallableUnitDescription description = InstallableUnitUtil.createIuDescription(String.valueOf(featureId) + ".feature.group", version);
        description.setProperty(FEATURE_TYPE_PROPERTY, Boolean.toString(true));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
    }

    public static IInstallableUnit createIUWithCapabilitiesAndFilter(String id, String version, Collection<IProvidedCapability> capabilities, String filter) {
        MetadataFactory.InstallableUnitDescription description = InstallableUnitUtil.createIuDescription(id, version);
        description.addProvidedCapabilities(capabilities);
        description.setFilter(filter);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
    }

    public static IInstallableUnit createIUArtifact(String id, String version, String artifactId, String artifactVersion) {
        MetadataFactory.InstallableUnitDescription description = InstallableUnitUtil.createIuDescription(id, version);
        description.setArtifacts(new IArtifactKey[]{new ArtifactKey("type", artifactId, Version.create((String)artifactVersion))});
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
    }

    public static IInstallableUnit createIURequirement(String id, String version, String requiredId, String requiredVersionRange) {
        MetadataFactory.InstallableUnitDescription description = InstallableUnitUtil.createIuDescription(id, version);
        IRequirement requiredCapability = InstallableUnitUtil.createRequirement(requiredId, requiredVersionRange);
        description.addRequirements(Arrays.asList(requiredCapability));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
    }

    private static MetadataFactory.InstallableUnitDescription createIuDescription(String id, String version) {
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        description.setId(id);
        description.setVersion(Version.create((String)version));
        description.addProvidedCapabilities(InstallableUnitUtil.createProvidedCapability(IU_CAPABILITY_NS, id, version));
        return description;
    }

    private static List<IProvidedCapability> createProvidedCapability(String namespace, String name, String version) {
        return Arrays.asList(new ProvidedCapability(namespace, name, Version.create((String)version)));
    }

    static IRequirement createRequirement(String requiredId, String requiredVersionRange) {
        return MetadataFactory.createRequirement((String)IU_CAPABILITY_NS, (String)requiredId, (VersionRange)new VersionRange(requiredVersionRange), null, (boolean)false, (boolean)false, (boolean)true);
    }

    static IRequirement createStrictRequirement(String requiredId, String requiredVersion) {
        Version parsedVersion = Version.create((String)requiredVersion);
        return MetadataFactory.createRequirement((String)IU_CAPABILITY_NS, (String)requiredId, (VersionRange)new VersionRange(parsedVersion, true, parsedVersion, true), null, (boolean)false, (boolean)false, (boolean)true);
    }
}

