/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.testutil;

import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.junit.Assert;

public class MatchingItemFinder {
    public static <T> T getUnique(Matcher<T> condition, Iterable<? extends T> collection) {
        T result = null;
        for (T item : collection) {
            if (!condition.matches(item)) continue;
            if (result == null) {
                result = item;
                continue;
            }
            MatchingItemFinder.reportMismatch(condition, collection);
        }
        if (result == null) {
            MatchingItemFinder.reportMismatch(condition, collection);
        }
        return result;
    }

    private static <T> void reportMismatch(Matcher<T> condition, Iterable<? extends T> collection) {
        StringDescription description = new StringDescription();
        description.appendText("Expected a collection with exactly one item: ").appendDescriptionOf(condition);
        description.appendText("\nbut was: ").appendValue(collection);
        Assert.fail((String)description.toString());
    }
}

