/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.streaming.testutil;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.IArtifactSink;
import org.eclipse.tycho.repository.streaming.testutil.ProbeOutputStream;
import org.eclipse.tycho.test.util.StatusMatchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;

public class ProbeArtifactSink
implements IArtifactSink {
    private IArtifactKey artifactKey;
    ProbeOutputStream sink = null;
    private boolean aborted = false;
    private boolean committed = false;

    public static ProbeArtifactSink newArtifactSinkFor(IArtifactKey artifactKey) {
        return new ProbeArtifactSink(artifactKey);
    }

    public ProbeArtifactSink(IArtifactKey artifactKey) {
        this.artifactKey = artifactKey;
    }

    public IArtifactKey getArtifactToBeWritten() {
        return this.artifactKey;
    }

    public boolean canBeginWrite() {
        return !this.committed;
    }

    public OutputStream beginWrite() {
        if (this.committed) {
            Assert.fail((String)"Can not call beginWrite() after commitWrite()");
        }
        this.aborted = false;
        this.sink = new ProbeOutputStream();
        return this.sink;
    }

    public boolean writeIsStarted() {
        return this.sink != null;
    }

    public void abortWrite() {
        if (!this.writeIsStarted()) {
            throw new AssertionError((Object)"Should not call abortWrite() if beginWrite() wasn't called");
        }
        if (this.writeIsCommitted()) {
            throw new AssertionError((Object)"Can not call abortWrite() after commitWrite()");
        }
        this.aborted = true;
    }

    public boolean writeIsAborted() {
        return this.aborted;
    }

    public void commitWrite() {
        if (!this.writeIsStarted()) {
            throw new AssertionError((Object)"Should not call abortWrite() if beginWrite() wasn't called");
        }
        if (this.writeIsAborted()) {
            throw new AssertionError((Object)"Can not call commitWrite() after abortWrite()");
        }
        this.committed = true;
    }

    public boolean writeIsCommitted() {
        return this.committed;
    }

    public int committedBytes() {
        if (!this.writeIsCommitted()) {
            return 0;
        }
        return this.sink.writtenBytes();
    }

    public Set<String> getFilesInZip() throws IOException {
        if (!this.writeIsCommitted()) {
            return Collections.emptySet();
        }
        return this.sink.getFilesInZip();
    }

    public void checkConsistencyWithStatus(IStatus status) {
        Assert.assertNotNull((Object)status);
        if (this.writeIsCommitted()) {
            MatcherAssert.assertThat((Object)status, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.either(StatusMatchers.okStatus()).or(StatusMatchers.warningStatus())));
        }
        if (this.writeIsAborted()) {
            MatcherAssert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.errorStatus()));
        }
        if (this.writeIsStarted()) {
            Assert.assertTrue((this.writeIsAborted() || this.writeIsCommitted() ? 1 : 0) != 0);
        }
    }
}

