/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.testutil;

import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.tycho.repository.p2base.artifact.provider.IArtifactProvider;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ArtifactRepositoryMatchers {
    static String keyToString(IArtifactKey artifactKey) {
        return String.valueOf(artifactKey.getClassifier()) + ":" + artifactKey.getId() + ":" + artifactKey.getVersion();
    }

    public static Matcher<IArtifactProvider> contains(final IArtifactKey artifactKey) {
        return new TypeSafeMatcher<IArtifactProvider>(){

            public void describeTo(Description description) {
                description.appendText("artifact repository with entry " + ArtifactRepositoryMatchers.keyToString(artifactKey));
            }

            public boolean matchesSafely(IArtifactProvider repo) {
                return repo.contains(artifactKey);
            }
        };
    }
}

