/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import java.io.File;
import org.eclipse.tycho.BuildDirectory;
import org.eclipse.tycho.BuildOutputDirectory;
import org.eclipse.tycho.ReactorProjectIdentities;

public class ReactorProjectIdentitiesStub
extends ReactorProjectIdentities {
    private static final String DUMMY_GROUP_ID = "dummy-group";
    private static final String DUMMY_VERSION = "0.1.2-SNAPSHOT";
    private final File projectRoot;
    private final BuildDirectory targetFolder;
    private final String artifactId;

    public ReactorProjectIdentitiesStub(String artifactId) {
        this.artifactId = artifactId;
        this.projectRoot = null;
        this.targetFolder = null;
    }

    public ReactorProjectIdentitiesStub(File projectRoot) {
        this(projectRoot, projectRoot.getName());
    }

    public ReactorProjectIdentitiesStub(File projectRoot, String artifactId) {
        this.projectRoot = projectRoot;
        this.targetFolder = new BuildOutputDirectory(new File(projectRoot, "target"));
        this.artifactId = artifactId;
        this.targetFolder.getLocation().mkdirs();
    }

    private static <T> T unlessNull(T value) {
        if (value == null) {
            throw new UnsupportedOperationException();
        }
        return value;
    }

    public String getGroupId() {
        return DUMMY_GROUP_ID;
    }

    public String getArtifactId() {
        return ReactorProjectIdentitiesStub.unlessNull(this.artifactId);
    }

    public String getVersion() {
        return DUMMY_VERSION;
    }

    public File getBasedir() {
        return ReactorProjectIdentitiesStub.unlessNull(this.projectRoot);
    }

    public BuildDirectory getBuildDirectory() {
        return ReactorProjectIdentitiesStub.unlessNull(this.targetFolder);
    }
}

