/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.test.util;

import org.eclipse.tycho.test.util.Activator;
import org.junit.rules.ExternalResource;
import org.osgi.framework.ServiceRegistration;

public class StubServiceRegistration<T>
extends ExternalResource {
    private final Class<T> type;
    private T instance;
    private ServiceRegistration<T> serviceRegistration;

    public StubServiceRegistration(Class<T> type, T instance) {
        this.type = type;
        this.instance = instance;
    }

    public StubServiceRegistration(Class<T> type) {
        this.type = type;
        this.instance = null;
    }

    protected void before() throws Throwable {
        if (this.instance != null) {
            this.internalRegisterService();
        }
    }

    public void registerService(T instance) {
        this.instance = instance;
        this.internalRegisterService();
    }

    private void internalRegisterService() {
        if (this.serviceRegistration != null) {
            throw new IllegalStateException("This instance can only register one service");
        }
        this.serviceRegistration = Activator.getContext().registerService(this.type, this.instance, null);
    }

    protected void after() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        } else {
            String classNameWithGenericParameter = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "<" + this.type.getSimpleName() + ">";
            System.out.println("Warning: " + classNameWithGenericParameter + " instance did not register a service; provide an implementation in the constructor or via setService");
        }
    }
}

