/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.async.api.OrderedEventContext;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.l2.msg.IBatchableGroupMessage;
import com.tc.l2.msg.SyncReplicationActivity;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ReplicationMessage
extends AbstractGroupMessage
implements OrderedEventContext,
IBatchableGroupMessage<SyncReplicationActivity> {
    public static final int IGNORED = 0;
    private List<SyncReplicationActivity> activities;
    long rid = 0L;
    private boolean didCreateLocally;

    public static ReplicationMessage createActivityContainer(SyncReplicationActivity activity) {
        Assert.assertNotNull(activity);
        return new ReplicationMessage(activity);
    }

    public static ReplicationMessage createLocalContainer(SyncReplicationActivity activity) {
        Assert.assertNotNull(activity);
        ReplicationMessage message = new ReplicationMessage(activity);
        message.didCreateLocally = false;
        return message;
    }

    public ReplicationMessage() {
        super(0);
        this.didCreateLocally = false;
    }

    protected ReplicationMessage(int type) {
        super(type);
        this.didCreateLocally = false;
    }

    private ReplicationMessage(SyncReplicationActivity activity) {
        super(0);
        this.activities = new ArrayList<SyncReplicationActivity>();
        this.activities.add(activity);
        this.didCreateLocally = true;
    }

    public void setReplicationID(long rid) {
        this.rid = rid;
    }

    @Override
    public long getSequenceID() {
        return this.rid;
    }

    @Override
    public void addToBatch(SyncReplicationActivity element) {
        this.activities.add(element);
    }

    @Override
    public int getBatchSize() {
        return this.activities.size();
    }

    public List<SyncReplicationActivity> getActivities() {
        Assert.assertFalse(this.didCreateLocally);
        return this.activities;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        int messageType = this.getType();
        switch (messageType) {
            case 0: {
                this.rid = in.readLong();
                int batchSize = in.readInt();
                Assert.assertTrue(batchSize > 0);
                this.activities = new ArrayList<SyncReplicationActivity>();
                for (int i = 0; i < batchSize; ++i) {
                    SyncReplicationActivity activity = SyncReplicationActivity.deserializeFrom(in);
                    Assert.assertNotNull(activity);
                    this.activities.add(activity);
                }
                break;
            }
        }
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        int messageType = this.getType();
        switch (messageType) {
            case 0: {
                out.writeLong(this.rid);
                int batchSize = this.activities.size();
                Assert.assertTrue(batchSize > 0);
                out.writeInt(batchSize);
                for (SyncReplicationActivity activity : this.activities) {
                    activity.serializeTo(out);
                }
                break;
            }
        }
    }

    public String getDebugId() {
        return this.getType() + " " + (this.activities != null ? this.activities.size() + " activities" : "no activities");
    }

    public String toString() {
        return "ReplicationMessage{rid=" + this.rid + ", " + (this.activities != null ? this.activities.size() + " activities" : "no activities") + "}";
    }

    @Override
    public AbstractGroupMessage asAbstractGroupMessage() {
        return this;
    }
}

