/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema;

import com.tc.util.Assert;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class L2Info
implements Serializable {
    static final long serialVersionUID = 7607194631717518924L;
    public static final String IMPLICIT_L2_NAME = "localhost";
    private final String name;
    private final String host;
    private InetAddress hostAddress;
    private final int jmxPort;
    private final int tsaPort;
    private final String tsaGroupBind;
    private final int tsaGroupPort;
    private final int managementPort;
    private final String securityHostname;
    private Integer hashCode;

    public L2Info(String name, String host, int jmxPort, int tsaPort, String tsaGroupBind, int tsaGroupPort, int managementPort, String securityHostname) {
        Assert.assertNotBlank((String)host);
        Assert.eval((jmxPort >= 0 ? 1 : 0) != 0);
        this.name = name;
        this.host = host;
        this.jmxPort = jmxPort;
        this.tsaPort = tsaPort;
        this.tsaGroupBind = tsaGroupBind;
        this.tsaGroupPort = tsaGroupPort;
        this.managementPort = managementPort;
        this.securityHostname = securityHostname;
        this.safeGetHostAddress();
    }

    public L2Info(L2Info other) {
        this(other.name(), other.host(), other.jmxPort(), other.tsaPort(), other.tsaGroupBind(), other.tsaGroupPort(), other.managementPort(), other.securityHostname());
    }

    public String name() {
        return this.name;
    }

    public String host() {
        return this.host;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.hostAddress != null) {
            return this.hostAddress;
        }
        this.hostAddress = IMPLICIT_L2_NAME.equals(this.host) || "127.0.0.1".equals(this.host) ? InetAddress.getLocalHost() : InetAddress.getByName(this.host);
        return this.hostAddress;
    }

    public String getCanonicalHostName() throws UnknownHostException {
        return this.getInetAddress().getCanonicalHostName();
    }

    public String safeGetCanonicalHostName() {
        try {
            return this.getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            return null;
        }
    }

    public String getHostAddress() throws UnknownHostException {
        return this.getInetAddress().getHostAddress();
    }

    public String safeGetHostAddress() {
        try {
            return this.getInetAddress().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            return null;
        }
    }

    public int jmxPort() {
        return this.jmxPort;
    }

    public int managementPort() {
        return this.managementPort;
    }

    public int tsaPort() {
        return this.tsaPort;
    }

    public String tsaGroupBind() {
        return this.tsaGroupBind;
    }

    public int tsaGroupPort() {
        return this.tsaGroupPort;
    }

    public String securityHostname() {
        return this.securityHostname;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + this.jmxPort;
            result = 31 * result + this.managementPort;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.securityHostname == null ? 0 : this.securityHostname.hashCode());
            result = 31 * result + (this.tsaGroupBind == null ? 0 : this.tsaGroupBind.hashCode());
            result = 31 * result + this.tsaGroupPort;
            result = 31 * result + this.tsaPort;
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        L2Info other = (L2Info)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.jmxPort != other.jmxPort) {
            return false;
        }
        if (this.managementPort != other.managementPort) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.securityHostname == null ? other.securityHostname != null : !this.securityHostname.equals(other.securityHostname)) {
            return false;
        }
        if (this.tsaGroupBind == null ? other.tsaGroupBind != null : !this.tsaGroupBind.equals(other.tsaGroupBind)) {
            return false;
        }
        if (this.tsaGroupPort != other.tsaGroupPort) {
            return false;
        }
        return this.tsaPort == other.tsaPort;
    }
}

