/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.setup.sources;

import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.sources.ConfigurationSource;
import com.tc.util.Assert;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileConfigurationSource
implements ConfigurationSource {
    private final String path;
    private final File defaultDirectory;

    public FileConfigurationSource(String path, File defaultDirectory) {
        Assert.assertNotBlank((String)path);
        this.path = path;
        this.defaultDirectory = defaultDirectory;
    }

    @Override
    public InputStream getInputStream(long maxTimeoutMillis) throws ConfigurationSetupException {
        File file = this.createFile();
        if (!file.exists()) {
            throw new ConfigurationSetupException("The file '" + file.getAbsolutePath() + "' does not exist");
        }
        if (file.isDirectory()) {
            throw new ConfigurationSetupException("The \"file\" '" + file.getAbsolutePath() + "' is actually a directory");
        }
        try {
            FileInputStream out = new FileInputStream(file);
            return out;
        }
        catch (IOException ioe) {
            throw new ConfigurationSetupException("We can't read data from the file '" + file.getAbsolutePath() + "': " + ioe.getLocalizedMessage());
        }
    }

    @Override
    public File directoryLoadedFrom() {
        return this.createFile().getParentFile();
    }

    private File createFile() {
        File file = new File(this.path);
        if (!file.isAbsolute()) {
            file = new File(this.defaultDirectory, this.path);
        }
        return file;
    }

    @Override
    public boolean isTrusted() {
        return false;
    }

    public String toString() {
        return "file at '" + this.createFile().getAbsolutePath() + "'";
    }
}

