/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.core.BufferManager;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SocketChannel;

class ClearTextBufferManager
implements BufferManager {
    private static final TCLogger logger = TCLogging.getLogger(ClearTextBufferManager.class);
    private static final String BUFFER_SIZE = "clear.text.buffer.size";
    private static final int BUFFER_SIZE_KB = Integer.getInteger("clear.text.buffer.size", 16) * 1024;
    private final SocketChannel channel;
    private final ByteBuffer sendBuffer = ByteBuffer.allocate(BUFFER_SIZE_KB);
    private final ByteBuffer recvBuffer = ByteBuffer.allocate(BUFFER_SIZE_KB);

    ClearTextBufferManager(SocketChannel channel) {
        this.channel = channel;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ClearTextBufferManager clear.text.buffer.size " + BUFFER_SIZE_KB));
        }
    }

    @Override
    public int sendFromBuffer() throws IOException {
        this.sendBuffer.flip();
        int written = this.channel.write(this.sendBuffer);
        this.sendBuffer.compact();
        if (written == -1) {
            throw new EOFException();
        }
        return written;
    }

    @Override
    public int recvToBuffer() throws IOException {
        int read = this.channel.read(this.recvBuffer);
        if (read == -1) {
            throw new EOFException();
        }
        return read;
    }

    @Override
    public void close() {
    }

    @Override
    public int forwardFromReadBuffer(ByteBuffer dest) {
        this.recvBuffer.flip();
        int forwarded = ClearTextBufferManager.forwardBuffer(this.recvBuffer, dest);
        this.recvBuffer.compact();
        return forwarded;
    }

    @Override
    public int forwardFromReadBuffer(GatheringByteChannel gbc) throws IOException {
        this.recvBuffer.flip();
        int forwarded = gbc.write(this.recvBuffer);
        this.recvBuffer.compact();
        if (forwarded == -1) {
            throw new EOFException();
        }
        return forwarded;
    }

    @Override
    public int forwardToWriteBuffer(ByteBuffer src) {
        return ClearTextBufferManager.forwardBuffer(src, this.sendBuffer);
    }

    @Override
    public int forwardToWriteBuffer(ScatteringByteChannel sbc) throws IOException {
        int read = sbc.read(this.sendBuffer);
        if (read == -1) {
            throw new EOFException();
        }
        return read;
    }

    private static int forwardBuffer(ByteBuffer source, ByteBuffer dest) {
        int size = Math.min(dest.remaining(), source.remaining());
        if (size > 0) {
            ByteBuffer tmpBuf = source.duplicate();
            tmpBuf.limit(tmpBuf.position() + size);
            dest.put(tmpBuf);
            source.position(source.position() + size);
        }
        return size;
    }
}

