/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesImpl;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

class SocketParams {
    private static final TCLogger logger = TCLogging.getLogger(SocketParams.class);
    private static final String RECV_BUFFER = "recv.buffer";
    private static final String SEND_BUFFER = "send.buffer";
    private static final String TCP_NO_DELAY = "tcpnodelay";
    private static final String KEEP_ALIVE = "keepalive";
    private final int recvBuffer;
    private final int sendBuffer;
    private final boolean tcpNoDelay;
    private final boolean keepAlive;

    SocketParams() {
        TCProperties props = TCPropertiesImpl.getProperties().getPropertiesFor("net.core");
        this.recvBuffer = props.getInt(RECV_BUFFER, -1);
        this.sendBuffer = props.getInt(SEND_BUFFER, -1);
        this.keepAlive = props.getBoolean(KEEP_ALIVE);
        this.tcpNoDelay = props.getBoolean(TCP_NO_DELAY);
    }

    void applySocketParams(Socket s) {
        if (this.sendBuffer > 0) {
            try {
                s.setSendBufferSize(this.sendBuffer);
            }
            catch (SocketException e) {
                logger.error((Object)("error setting sendBuffer to " + this.sendBuffer), (Throwable)e);
            }
        }
        if (this.recvBuffer > 0) {
            try {
                s.setReceiveBufferSize(this.recvBuffer);
            }
            catch (SocketException e) {
                logger.error((Object)("error setting recvBuffer to " + this.recvBuffer), (Throwable)e);
            }
        }
        try {
            s.setTcpNoDelay(this.tcpNoDelay);
        }
        catch (SocketException e) {
            logger.error((Object)("error setting TcpNoDelay to " + this.tcpNoDelay), (Throwable)e);
        }
        try {
            s.setKeepAlive(this.keepAlive);
        }
        catch (SocketException e) {
            logger.error((Object)("error setting KeepAlive to " + this.keepAlive), (Throwable)e);
        }
    }

    void applyServerSocketParams(ServerSocket s, boolean reuseAddress) {
        try {
            s.setReuseAddress(reuseAddress);
        }
        catch (SocketException e) {
            logger.error((Object)("error setting recvBuffer to " + this.recvBuffer), (Throwable)e);
        }
        if (this.recvBuffer > 0) {
            try {
                s.setReceiveBufferSize(this.recvBuffer);
            }
            catch (SocketException e) {
                logger.error((Object)("error setting recvBuffer to " + this.recvBuffer), (Throwable)e);
            }
        }
    }
}

