/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.NIOWorkarounds;
import com.tc.net.TCSocketAddress;
import com.tc.net.core.BufferManager;
import com.tc.net.core.BufferManagerFactory;
import com.tc.net.core.ClearTextBufferManagerFactory;
import com.tc.net.core.CoreNIOServices;
import com.tc.net.core.PipeSocket;
import com.tc.net.core.SocketParams;
import com.tc.net.core.TCChannelReader;
import com.tc.net.core.TCChannelWriter;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionManagerImpl;
import com.tc.net.core.event.TCConnectionEventCaller;
import com.tc.net.core.event.TCConnectionEventListener;
import com.tc.net.core.security.TCSecurityManager;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.TCProtocolAdaptor;
import com.tc.net.protocol.transport.WireProtocolGroupMessageImpl;
import com.tc.net.protocol.transport.WireProtocolHeader;
import com.tc.net.protocol.transport.WireProtocolMessage;
import com.tc.net.protocol.transport.WireProtocolMessageImpl;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import com.tc.util.TCTimeoutException;
import com.tc.util.concurrent.SetOnceFlag;
import com.tc.util.concurrent.SetOnceRef;
import com.tc.util.concurrent.ThreadUtil;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

final class TCConnectionImpl
implements TCConnection,
TCChannelReader,
TCChannelWriter {
    private static final long NO_CONNECT_TIME = -1L;
    private static final TCLogger logger = TCLogging.getLogger(TCConnection.class);
    private static final long WARN_THRESHOLD = 0x400000L;
    private volatile CoreNIOServices commWorker;
    private volatile SocketChannel channel;
    private volatile BufferManager bufferManager;
    private volatile PipeSocket pipeSocket;
    private final BufferManagerFactory bufferManagerFactory;
    private final AtomicBoolean transportEstablished = new AtomicBoolean(false);
    private final LinkedList<TCNetworkMessage> writeMessages = new LinkedList();
    private final TCConnectionManagerImpl parent;
    private final TCConnectionEventCaller eventCaller = new TCConnectionEventCaller(logger);
    private final AtomicLong lastDataWriteTime = new AtomicLong(System.currentTimeMillis());
    private final AtomicLong lastDataReceiveTime = new AtomicLong(System.currentTimeMillis());
    private final AtomicLong connectTime = new AtomicLong(-1L);
    private final List<TCConnectionEventListener> eventListeners = new CopyOnWriteArrayList<TCConnectionEventListener>();
    private final TCProtocolAdaptor protocolAdaptor;
    private final AtomicBoolean isSocketEndpoint = new AtomicBoolean(false);
    private final SetOnceFlag closed = new SetOnceFlag();
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final SetOnceRef<TCSocketAddress> localSocketAddress = new SetOnceRef();
    private final SetOnceRef<TCSocketAddress> remoteSocketAddress = new SetOnceRef();
    private final SocketParams socketParams;
    private final AtomicLong totalRead = new AtomicLong(0L);
    private final AtomicLong totalWrite = new AtomicLong(0L);
    private final ArrayList<WriteContext> writeContexts = new ArrayList();
    private final Object pipeSocketWriteInterestLock = new Object();
    private boolean hasPipeSocketWriteInterest = false;
    private int writeBufferSize = 0;
    private static final boolean MSG_GROUPING_ENABLED = TCPropertiesImpl.getProperties().getBoolean("tc.messages.grouping.enabled");
    private static final int MSG_GROUPING_MAX_SIZE_BYTES = TCPropertiesImpl.getProperties().getInt("tc.messages.grouping.maxSizeKiloBytes", 128) * 1024;
    private static final boolean MESSSAGE_PACKUP = TCPropertiesImpl.getProperties().getBoolean("tc.messages.packup.enabled", true);
    private final Object readerLock = new Object();
    private final Object writerLock = new Object();

    TCConnectionImpl(TCConnectionEventListener listener, TCProtocolAdaptor adaptor, TCConnectionManagerImpl managerJDK14, CoreNIOServices nioServiceThread, SocketParams socketParams, TCSecurityManager securityManager) {
        this(listener, adaptor, null, managerJDK14, nioServiceThread, socketParams, securityManager);
    }

    TCConnectionImpl(TCConnectionEventListener listener, TCProtocolAdaptor adaptor, SocketChannel ch, TCConnectionManagerImpl parent, CoreNIOServices nioServiceThread, SocketParams socketParams, TCSecurityManager securityManager) {
        Assert.assertNotNull((Object)parent);
        Assert.assertNotNull((Object)adaptor);
        this.parent = parent;
        this.protocolAdaptor = adaptor;
        if (listener != null) {
            this.addListener(listener);
        }
        this.channel = ch;
        this.bufferManagerFactory = securityManager != null ? securityManager.getBufferManagerFactory() : new ClearTextBufferManagerFactory();
        if (ch != null) {
            socketParams.applySocketParams(ch.socket());
            this.bufferManager = this.bufferManagerFactory.createBufferManager(ch, false);
        }
        this.socketParams = socketParams;
        this.commWorker = nioServiceThread;
    }

    public void setCommWorker(CoreNIOServices worker) {
        this.commWorker = worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeImpl(Runnable callback) {
        block17: {
            Object object;
            Assert.assertTrue((boolean)this.closed.isSet());
            this.transportEstablished.set(false);
            try {
                if (this.channel != null) {
                    this.commWorker.cleanupChannel(this.channel, callback);
                } else {
                    callback.run();
                }
            }
            finally {
                object = this.writeMessages;
                synchronized (object) {
                    this.writeMessages.clear();
                }
            }
            try {
                if (this.pipeSocket == null) break block17;
                object = this.pipeSocketWriteInterestLock;
                synchronized (object) {
                    this.writeBufferSize = 0;
                }
                this.pipeSocket.dispose();
            }
            catch (IOException ioe) {
                logger.warn((Object)"error closing pipesocket", (Throwable)ioe);
            }
        }
    }

    protected void finishConnect() throws IOException {
        Assert.assertNotNull((Object)"channel", (Object)this.channel);
        this.recordSocketAddress(this.channel.socket());
        this.setConnected(true);
        this.eventCaller.fireConnectEvent(this.eventListeners, this);
    }

    private void connectImpl(TCSocketAddress addr, int timeout) throws IOException, TCTimeoutException {
        SocketChannel newSocket = null;
        InetSocketAddress inetAddr = new InetSocketAddress(addr.getAddress(), addr.getPort());
        for (int i = 1; i <= 3; ++i) {
            try {
                newSocket = this.createChannel();
                newSocket.configureBlocking(true);
                newSocket.socket().connect(inetAddr, timeout);
                break;
            }
            catch (SocketTimeoutException ste) {
                Assert.eval((this.commWorker != null ? 1 : 0) != 0);
                this.commWorker.cleanupChannel(newSocket, null);
                throw new TCTimeoutException("Timeout of " + timeout + "ms occured connecting to " + addr, (Throwable)ste);
            }
            catch (ClosedSelectorException cse) {
                if (!NIOWorkarounds.connectWorkaround(cse)) {
                    throw cse;
                }
                logger.warn((Object)("Retrying connect to " + addr + ", attempt " + i));
                ThreadUtil.reallySleep(500L);
                continue;
            }
        }
        this.channel = newSocket;
        newSocket.configureBlocking(false);
        Assert.eval((this.commWorker != null ? 1 : 0) != 0);
        this.bufferManager = this.bufferManagerFactory.createBufferManager(newSocket, true);
        this.commWorker.requestReadInterest(this, newSocket);
    }

    private SocketChannel createChannel() throws IOException, SocketException {
        SocketChannel rv = SocketChannel.open();
        Socket s = rv.socket();
        this.socketParams.applySocketParams(s);
        return rv;
    }

    private Socket detachImpl() throws IOException {
        this.pipeSocket = new PipeSocket(this.channel.socket()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWrite() {
                Object object = TCConnectionImpl.this.pipeSocketWriteInterestLock;
                synchronized (object) {
                    TCConnectionImpl.this.writeBufferSize++;
                    if (!TCConnectionImpl.this.hasPipeSocketWriteInterest) {
                        TCConnectionImpl.this.commWorker.requestWriteInterest(TCConnectionImpl.this, TCConnectionImpl.this.channel);
                        TCConnectionImpl.this.hasPipeSocketWriteInterest = true;
                    }
                }
            }

            @Override
            public synchronized void close() throws IOException {
                super.close();
                TCConnectionImpl.this.channel.socket().close();
            }
        };
        return this.pipeSocket;
    }

    private boolean asynchConnectImpl(TCSocketAddress address) throws IOException {
        SocketChannel newSocket = this.createChannel();
        newSocket.configureBlocking(false);
        InetSocketAddress inetAddr = new InetSocketAddress(address.getAddress(), address.getPort());
        boolean rv = newSocket.connect(inetAddr);
        this.setConnected(rv);
        this.channel = newSocket;
        if (!rv) {
            this.commWorker.requestConnectInterest(this, newSocket);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doRead() throws IOException {
        Object object = this.readerLock;
        synchronized (object) {
            return this.doReadInternal();
        }
    }

    private int doReadInternal() throws IOException {
        int read;
        try {
            this.bufferManager.recvToBuffer();
        }
        catch (SSLException ssle) {
            logger.error((Object)("SSL error: " + ssle));
            this.closeReadOnException(ssle);
            return 0;
        }
        catch (IOException ioe) {
            this.closeReadOnException(ioe);
            return 0;
        }
        int totalBytesReadFromBuffer = 0;
        do {
            try {
                read = this.doReadFromBuffer();
                totalBytesReadFromBuffer += read;
            }
            catch (IOException ioe) {
                this.closeReadOnException(ioe);
                break;
            }
        } while (read != 0);
        this.totalRead.addAndGet(totalBytesReadFromBuffer);
        return totalBytesReadFromBuffer;
    }

    public int doReadFromBuffer() throws IOException {
        if (this.pipeSocket != null) {
            return this.bufferManager.forwardFromReadBuffer(this.pipeSocket.getInputPipeSinkChannel());
        }
        return this.doReadFromBufferInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doWrite() throws IOException {
        Object object = this.writerLock;
        synchronized (object) {
            return this.doWriteInternal();
        }
    }

    private int doWriteInternal() throws IOException {
        int channelWritten;
        int sent;
        int written;
        try {
            written = this.doWriteToBuffer();
        }
        catch (IOException ioe) {
            this.closeWriteOnException(ioe);
            return 0;
        }
        for (channelWritten = 0; channelWritten != written; channelWritten += sent) {
            try {
                sent = this.bufferManager.sendFromBuffer();
                continue;
            }
            catch (SSLHandshakeException she) {
                logger.error((Object)"SSL handshake error: unable to find valid certification path to requested target, closing connection.");
                this.closeWriteOnException(she);
                break;
            }
            catch (SSLException ssle) {
                logger.error((Object)("SSL error: " + ssle));
                this.closeWriteOnException(ssle);
                break;
            }
            catch (IOException ioe) {
                this.closeWriteOnException(ioe);
                break;
            }
        }
        this.totalWrite.addAndGet(channelWritten);
        return channelWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doWriteToBuffer() throws IOException {
        if (this.pipeSocket != null) {
            Object object = this.pipeSocketWriteInterestLock;
            synchronized (object) {
                int gotFromSendBuffer = this.bufferManager.forwardToWriteBuffer(this.pipeSocket.getOutputPipeSourceChannel());
                this.writeBufferSize -= gotFromSendBuffer;
                if (this.writeBufferSize == 0 && this.hasPipeSocketWriteInterest) {
                    this.commWorker.removeWriteInterest(this, this.channel);
                    this.hasPipeSocketWriteInterest = false;
                }
                return gotFromSendBuffer;
            }
        }
        return this.doWriteToBufferInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildWriteContextsFromMessages() {
        TCNetworkMessage[] messagesToWrite;
        LinkedList<TCNetworkMessage> linkedList = this.writeMessages;
        synchronized (linkedList) {
            if (this.closed.isSet()) {
                return;
            }
            messagesToWrite = this.writeMessages.toArray(new TCNetworkMessage[this.writeMessages.size()]);
            this.writeMessages.clear();
        }
        ArrayList<Object> currentBatch = MSG_GROUPING_ENABLED ? new ArrayList<TCNetworkMessage>() : null;
        int batchSize = 0;
        int batchMsgCount = 0;
        for (TCNetworkMessage element : messagesToWrite) {
            if (element instanceof WireProtocolMessage) {
                WireProtocolMessage ms = this.finalizeWireProtocolMessage((WireProtocolMessage)element, 1);
                this.writeContexts.add(new WriteContext((TCNetworkMessage)ms));
                continue;
            }
            if (0 == WireProtocolHeader.getProtocolForMessageClass((TCNetworkMessage)element)) {
                this.writeContexts.add(new WriteContext(element));
                continue;
            }
            if (MSG_GROUPING_ENABLED) {
                int realMessageSize = this.getRealMessgeSize(element.getTotalLength());
                if (!this.canBatch(realMessageSize, batchSize, batchMsgCount)) {
                    this.writeContexts.add(new WriteContext((TCNetworkMessage)this.buildWireProtocolMessageGroup(currentBatch)));
                    batchSize = 0;
                    batchMsgCount = 0;
                    currentBatch = new ArrayList();
                }
                batchSize += realMessageSize;
                ++batchMsgCount;
                currentBatch.add(element);
                continue;
            }
            this.writeContexts.add(new WriteContext((TCNetworkMessage)this.buildWireProtocolMessage(element)));
        }
        if (MSG_GROUPING_ENABLED && batchMsgCount > 0) {
            WireProtocolMessage ms = this.buildWireProtocolMessageGroup(currentBatch);
            this.writeContexts.add(new WriteContext((TCNetworkMessage)ms));
        }
    }

    private boolean canBatch(int realMessageSize, int currentBatchSize, int currentBatchMsgCount) {
        return 0 == currentBatchMsgCount || currentBatchSize + realMessageSize <= MSG_GROUPING_MAX_SIZE_BYTES && currentBatchMsgCount + 1 <= 65535;
    }

    private int getRealMessgeSize(int length) {
        return TCByteBufferFactory.getTotalBufferSizeNeededForMessageSize((int)length);
    }

    private int doReadFromBufferInternal() {
        boolean debug = logger.isDebugEnabled();
        TCByteBuffer[] readBuffers = this.getReadBuffers();
        int bytesRead = 0;
        for (TCByteBuffer readBuffer : readBuffers) {
            ByteBuffer buf = TCConnectionImpl.extractNioBuffer(readBuffer);
            if (!buf.hasRemaining()) continue;
            int read = this.bufferManager.forwardFromReadBuffer(buf);
            if (0 == read) break;
            bytesRead += read;
            if (buf.hasRemaining()) break;
        }
        Assert.eval((bytesRead >= 0 ? 1 : 0) != 0);
        if (debug) {
            logger.debug((Object)("Read " + bytesRead + " bytes on connection " + this.channel.toString()));
        }
        this.addNetworkData(readBuffers, bytesRead);
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doWriteToBufferInternal() {
        boolean debug = logger.isDebugEnabled();
        int totalBytesWritten = 0;
        if (this.writeContexts.size() <= 0) {
            this.buildWriteContextsFromMessages();
        }
        while (this.writeContexts.size() > 0) {
            int written;
            WriteContext context = this.writeContexts.get(0);
            TCByteBuffer[] buffers = context.entireMessageData;
            long bytesWritten = 0L;
            int nn = buffers.length;
            for (int i = context.index; i < nn && (written = this.bufferManager.forwardToWriteBuffer(buffers[i].getNioBuffer())) != 0; ++i) {
                bytesWritten += (long)written;
                if (buffers[i].hasRemaining()) break;
                context.incrementIndexAndCleanOld();
            }
            if (debug) {
                logger.debug((Object)("Wrote " + bytesWritten + " bytes on connection " + this.channel.toString()));
            }
            totalBytesWritten = (int)((long)totalBytesWritten + bytesWritten);
            if (context.done()) {
                if (debug) {
                    logger.debug((Object)("Complete message sent on connection " + this.channel.toString()));
                }
                context.writeComplete();
                this.writeContexts.remove(context);
                continue;
            }
            if (!debug) break;
            logger.debug((Object)("Message not yet completely sent on connection " + this.channel.toString()));
            break;
        }
        LinkedList<TCNetworkMessage> linkedList = this.writeMessages;
        synchronized (linkedList) {
            if (this.closed.isSet()) {
                return totalBytesWritten;
            }
            if (this.writeMessages.isEmpty() && this.writeContexts.isEmpty()) {
                this.commWorker.removeWriteInterest(this, this.channel);
            }
        }
        return totalBytesWritten;
    }

    private static ByteBuffer extractNioBuffer(TCByteBuffer buffer) {
        return buffer.getNioBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putMessageImpl(TCNetworkMessage message) {
        boolean newData;
        int msgCount;
        boolean debug = logger.isDebugEnabled();
        long bytesToWrite = 0L;
        bytesToWrite = message.getTotalLength();
        if (bytesToWrite >= 0x400000L) {
            logger.warn((Object)("Warning: Attempting to send a message (" + message.getClass().getName() + ") of size " + bytesToWrite + " bytes"));
        }
        LinkedList<TCNetworkMessage> linkedList = this.writeMessages;
        synchronized (linkedList) {
            if (this.closed.isSet()) {
                return;
            }
            this.writeMessages.addLast(message);
            msgCount = this.writeMessages.size();
            newData = msgCount == 1;
        }
        if (debug) {
            logger.debug((Object)("Connection (" + this.channel.toString() + ") has " + msgCount + " messages queued"));
        }
        if (newData) {
            if (debug) {
                logger.debug((Object)"New message on connection, registering for write interest");
            }
            this.commWorker.requestWriteInterest(this, this.channel);
        }
    }

    public final void asynchClose() {
        if (this.closed.attemptSet()) {
            this.closeImpl(this.createCloseCallback(null));
        }
    }

    public final boolean close(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("timeout cannot be less than or equal to zero");
        }
        if (this.closed.attemptSet()) {
            CountDownLatch latch = new CountDownLatch(1);
            this.closeImpl(this.createCloseCallback(latch));
            try {
                return latch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.warn((Object)"close interrupted");
                Thread.currentThread().interrupt();
                return this.isConnected();
            }
        }
        return this.isClosed();
    }

    private final Runnable createCloseCallback(final CountDownLatch latch) {
        final boolean fireClose = this.isConnected();
        return new Runnable(){

            @Override
            public void run() {
                TCConnectionImpl.this.setConnected(false);
                TCConnectionImpl.this.parent.connectionClosed(TCConnectionImpl.this);
                if (fireClose) {
                    TCConnectionImpl.this.eventCaller.fireCloseEvent(TCConnectionImpl.this.eventListeners, TCConnectionImpl.this);
                }
                if (latch != null) {
                    latch.countDown();
                }
            }
        };
    }

    public final boolean isClosed() {
        return this.closed.isSet();
    }

    public final boolean isConnected() {
        return this.connected.get();
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName()).append('@').append(this.hashCode()).append(":");
        buf.append(" connected: ").append(this.isConnected());
        buf.append(", closed: ").append(this.isClosed());
        if (this.isSocketEndpoint.get()) {
            buf.append(" local=");
            if (this.localSocketAddress.isSet()) {
                buf.append(this.localSocketAddress.get().getStringForm());
            } else {
                buf.append("[unknown]");
            }
            buf.append(" remote=");
            if (this.remoteSocketAddress.isSet()) {
                buf.append(this.remoteSocketAddress.get().getStringForm());
            } else {
                buf.append("[unknown]");
            }
        }
        buf.append(" connect=[");
        long connect = this.getConnectTime();
        if (connect != -1L) {
            buf.append(new Date(connect));
        } else {
            buf.append("no connect time");
        }
        buf.append(']');
        buf.append(" idle=").append(this.getIdleTime()).append("ms");
        buf.append(" [").append(this.totalRead.get()).append(" read, ").append(this.totalWrite.get()).append(" write]");
        return buf.toString();
    }

    public final void addListener(TCConnectionEventListener listener) {
        if (listener == null) {
            return;
        }
        this.eventListeners.add(listener);
    }

    public final void removeListener(TCConnectionEventListener listener) {
        if (listener == null) {
            return;
        }
        this.eventListeners.remove(listener);
    }

    public final long getConnectTime() {
        return this.connectTime.get();
    }

    public final long getIdleTime() {
        return System.currentTimeMillis() - (this.lastDataWriteTime.get() > this.lastDataReceiveTime.get() ? this.lastDataWriteTime.get() : this.lastDataReceiveTime.get());
    }

    public final long getIdleReceiveTime() {
        return System.currentTimeMillis() - this.lastDataReceiveTime.get();
    }

    public final synchronized void connect(TCSocketAddress addr, int timeout) throws IOException, TCTimeoutException {
        if (this.closed.isSet() || this.connected.get()) {
            throw new IllegalStateException("Connection closed or already connected");
        }
        this.connectImpl(addr, timeout);
        this.finishConnect();
    }

    public final synchronized boolean asynchConnect(TCSocketAddress addr) throws IOException {
        if (this.closed.isSet() || this.connected.get()) {
            throw new IllegalStateException("Connection closed or already connected");
        }
        boolean rv = this.asynchConnectImpl(addr);
        if (rv) {
            this.finishConnect();
        }
        return rv;
    }

    public final void putMessage(TCNetworkMessage message) {
        this.lastDataWriteTime.set(System.currentTimeMillis());
        this.putMessageImpl(message);
    }

    public final TCSocketAddress getLocalAddress() {
        return this.localSocketAddress.get();
    }

    public final TCSocketAddress getRemoteAddress() {
        return this.remoteSocketAddress.get();
    }

    private final void setConnected(boolean connected) {
        if (connected) {
            this.connectTime.set(System.currentTimeMillis());
        }
        this.connected.set(connected);
    }

    private final void recordSocketAddress(Socket socket) throws IOException {
        if (socket != null) {
            InetAddress localAddress = socket.getLocalAddress();
            InetAddress remoteAddress = socket.getInetAddress();
            if (remoteAddress != null && localAddress != null) {
                this.isSocketEndpoint.set(true);
                this.localSocketAddress.set(new TCSocketAddress(TCConnectionImpl.cloneInetAddress(localAddress), socket.getLocalPort()));
                this.remoteSocketAddress.set(new TCSocketAddress(TCConnectionImpl.cloneInetAddress(remoteAddress), socket.getPort()));
            } else {
                throw new IOException("socket is not connected");
            }
        }
    }

    private static InetAddress cloneInetAddress(InetAddress addr) {
        try {
            byte[] address = addr.getAddress();
            return InetAddress.getByAddress(address);
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    private final void addNetworkData(TCByteBuffer[] data, int length) {
        this.lastDataReceiveTime.set(System.currentTimeMillis());
        try {
            this.protocolAdaptor.addReadData((TCConnection)this, data, length);
        }
        catch (Exception e) {
            logger.error((Object)(this.toString() + " " + e.getMessage()));
            for (TCByteBuffer tcByteBuffer : data) {
                tcByteBuffer.clear();
            }
            this.eventCaller.fireErrorEvent(this.eventListeners, this, e, null);
            return;
        }
    }

    protected final TCByteBuffer[] getReadBuffers() {
        return this.protocolAdaptor.getReadBuffers();
    }

    protected final void fireErrorEvent(Exception e, TCNetworkMessage context) {
        this.eventCaller.fireErrorEvent(this.eventListeners, this, e, context);
    }

    public final Socket detach() throws IOException {
        this.parent.removeConnection(this);
        return this.detachImpl();
    }

    private WireProtocolMessage buildWireProtocolMessageGroup(ArrayList<TCNetworkMessage> messages) {
        int messageGroupSize = messages.size();
        Assert.assertTrue((Object)("Messages count not ok to build WireProtocolMessageGroup : " + messageGroupSize), (messageGroupSize > 0 && messageGroupSize <= 65535 ? 1 : 0) != 0);
        if (messageGroupSize == 1) {
            return this.buildWireProtocolMessage(messages.get(0));
        }
        WireProtocolGroupMessageImpl message = WireProtocolGroupMessageImpl.wrapMessages(messages, (TCConnection)this);
        Assert.eval((message.getSentCallback() == null ? 1 : 0) != 0);
        boolean hasNonNullCallbacks = false;
        final Runnable[] callbacks = new Runnable[messageGroupSize];
        for (int i = 0; i < messageGroupSize; ++i) {
            TCNetworkMessage oneMessage = messages.get(i);
            Assert.eval((!(oneMessage instanceof WireProtocolMessage) ? 1 : 0) != 0);
            Runnable callback = oneMessage.getSentCallback();
            if (null == callback) continue;
            callbacks[i] = callback;
            hasNonNullCallbacks = true;
        }
        if (hasNonNullCallbacks) {
            message.setSentCallback(new Runnable(){

                @Override
                public void run() {
                    for (Runnable callback : callbacks) {
                        if (callback == null) continue;
                        callback.run();
                    }
                }
            });
        }
        return this.finalizeWireProtocolMessage((WireProtocolMessage)message, messageGroupSize);
    }

    private WireProtocolMessage buildWireProtocolMessage(TCNetworkMessage message) {
        Assert.eval((!(message instanceof WireProtocolMessage) ? 1 : 0) != 0);
        TCNetworkMessage payload = message;
        WireProtocolMessage wireMessage = WireProtocolMessageImpl.wrapMessage((TCNetworkMessage)message, (TCConnection)this);
        Assert.eval((wireMessage.getSentCallback() == null ? 1 : 0) != 0);
        Runnable callback = payload.getSentCallback();
        if (callback != null) {
            wireMessage.setSentCallback(callback);
        }
        return this.finalizeWireProtocolMessage(wireMessage, 1);
    }

    private WireProtocolMessage finalizeWireProtocolMessage(WireProtocolMessage message, int messageCount) {
        WireProtocolHeader hdr = (WireProtocolHeader)message.getHeader();
        hdr.setSourceAddress(this.getLocalAddress().getAddressBytes());
        hdr.setSourcePort(this.getLocalAddress().getPort());
        hdr.setDestinationAddress(this.getRemoteAddress().getAddressBytes());
        hdr.setDestinationPort(this.getRemoteAddress().getPort());
        hdr.setMessageCount(messageCount);
        hdr.computeChecksum();
        return message;
    }

    public void closeReadOnException(IOException ioe) throws IOException {
        if (this.pipeSocket != null) {
            this.commWorker.removeReadInterest(this, this.channel);
            this.pipeSocket.closeRead();
        } else if (ioe instanceof EOFException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("EOF reading from channel " + this.channel.toString()));
            }
            this.eventCaller.fireEndOfFileEvent(this.eventListeners, this);
        } else {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("error reading from channel " + this.channel.toString() + ": " + ioe.getMessage()));
            }
            this.eventCaller.fireErrorEvent(this.eventListeners, this, ioe, null);
        }
    }

    public boolean isClosePending() {
        return this.pipeSocket != null && this.pipeSocket.isClosed();
    }

    public void closeWriteOnException(IOException ioe) throws IOException {
        if (this.pipeSocket != null) {
            this.commWorker.removeWriteInterest(this, this.channel);
            this.pipeSocket.closeWrite();
        } else if (ioe instanceof EOFException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("EOF writing to channel " + this.channel.toString()));
            }
            this.eventCaller.fireEndOfFileEvent(this.eventListeners, this);
        } else {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("error writing to channel " + this.channel.toString() + ": " + ioe.getMessage()));
            }
            if (NIOWorkarounds.windowsWritevWorkaround(ioe)) {
                return;
            }
            this.eventCaller.fireErrorEvent(this.eventListeners, this, ioe, null);
        }
    }

    public void addWeight(int addWeightBy) {
        this.commWorker.addWeight(this, addWeightBy, this.channel);
    }

    public void setTransportEstablished() {
        this.transportEstablished.set(true);
    }

    public boolean isTransportEstablished() {
        return this.transportEstablished.get();
    }

    static {
        logger.info((Object)("Comms Message Batching " + (MSG_GROUPING_ENABLED ? "enabled" : "disabled")));
    }

    protected static class WriteContext {
        private final TCNetworkMessage message;
        private int index = 0;
        private final TCByteBuffer[] entireMessageData;

        WriteContext(TCNetworkMessage message) {
            this.message = message;
            this.entireMessageData = MESSSAGE_PACKUP && TCByteBufferFactory.isPoolingEnabled() ? WriteContext.getPackedUpMessage(message.getEntireMessageData()) : WriteContext.getClonedMessage(message.getEntireMessageData());
        }

        boolean done() {
            int n = this.entireMessageData.length;
            for (int i = this.index; i < n; ++i) {
                if (!this.entireMessageData[i].hasRemaining()) continue;
                return false;
            }
            return true;
        }

        void incrementIndexAndCleanOld() {
            if (MESSSAGE_PACKUP) {
                this.entireMessageData[this.index].recycle();
            }
            this.entireMessageData[this.index] = null;
            ++this.index;
        }

        void writeComplete() {
            this.message.wasSent();
        }

        private static TCByteBuffer[] getClonedMessage(TCByteBuffer[] sourceMessageByteBuffers) {
            TCByteBuffer[] msgData = sourceMessageByteBuffers;
            TCByteBuffer[] clonedMessageData = new TCByteBuffer[msgData.length];
            for (int i = 0; i < msgData.length; ++i) {
                clonedMessageData[i] = msgData[i].duplicate().asReadOnlyBuffer();
            }
            return clonedMessageData;
        }

        protected static TCByteBuffer[] getPackedUpMessage(TCByteBuffer[] sourceMessageByteBuffers) {
            int srcIndex = 0;
            int srcOffset = 0;
            int dstIndex = 0;
            int srcRem = 0;
            int dstRem = 0;
            int written = 0;
            int len = 0;
            for (TCByteBuffer sourceMessageByteBuffer : sourceMessageByteBuffers) {
                len += sourceMessageByteBuffer.limit();
            }
            TCByteBuffer[] packedUpMessageByteBuffers = TCByteBufferFactory.getFixedSizedInstancesForLength((boolean)false, (int)len);
            srcOffset = sourceMessageByteBuffers[srcIndex].arrayOffset();
            while (srcIndex < sourceMessageByteBuffers.length) {
                dstRem = packedUpMessageByteBuffers[dstIndex].remaining();
                srcRem = sourceMessageByteBuffers[srcIndex].arrayOffset() + sourceMessageByteBuffers[srcIndex].limit() - srcOffset;
                if (srcRem > dstRem) {
                    packedUpMessageByteBuffers[dstIndex].put(sourceMessageByteBuffers[srcIndex].array(), srcOffset, dstRem);
                    srcOffset += dstRem;
                    ++dstIndex;
                    written += dstRem;
                    continue;
                }
                if (srcRem == dstRem) {
                    packedUpMessageByteBuffers[dstIndex].put(sourceMessageByteBuffers[srcIndex].array(), srcOffset, dstRem);
                    ++dstIndex;
                    srcOffset = ++srcIndex < sourceMessageByteBuffers.length ? sourceMessageByteBuffers[srcIndex].arrayOffset() : 0;
                    written += dstRem;
                    continue;
                }
                packedUpMessageByteBuffers[dstIndex].put(sourceMessageByteBuffers[srcIndex].array(), srcOffset, srcRem);
                srcOffset = ++srcIndex < sourceMessageByteBuffers.length ? sourceMessageByteBuffers[srcIndex].arrayOffset() : 0;
                written += srcRem;
            }
            for (TCByteBuffer compactedMessageByteBuffer : packedUpMessageByteBuffers) {
                compactedMessageByteBuffer.flip();
            }
            if (len != written) {
                Assert.assertEquals((Object)"Comms Write: packed-up message length is different from original. ", (int)len, (int)written);
            }
            return packedUpMessageByteBuffers;
        }
    }
}

