/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol;

import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.core.ConnectionInfo;
import com.tc.net.core.TCConnection;
import com.tc.net.protocol.IllegalReconnectException;
import com.tc.net.protocol.LayeredNetworkStackHarness;
import com.tc.net.protocol.NetworkLayer;
import com.tc.net.protocol.NetworkStackID;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.transport.ClientConnectionEstablisher;
import com.tc.net.protocol.transport.ClientMessageTransport;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionWatcher;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportFactory;
import com.tc.net.protocol.transport.MessageTransportInitiator;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.util.Assert;
import com.tc.util.TCTimeoutException;
import com.tc.util.concurrent.SetOnceFlag;
import java.io.IOException;
import java.util.Collection;

public class ClientNetworkStackHarness
extends LayeredNetworkStackHarness {
    protected ClientMessageTransport transport;
    protected ClientMessageChannel channel;
    private final MessageTransportFactory transportFactory;
    private final SetOnceFlag finalized = new SetOnceFlag();
    private final boolean allowConnectionReplace;

    public ClientNetworkStackHarness(MessageTransportFactory transportFactory, ClientMessageChannel channel, boolean allowConnectionReplace) {
        this.transportFactory = transportFactory;
        this.channel = channel;
        this.allowConnectionReplace = allowConnectionReplace;
    }

    @Override
    public final ClientMessageTransport attachNewConnection(TCConnection connection) throws IllegalReconnectException {
        Assert.eval((Object)"Attempt to connect a transport to a stack that hasn't been finalized.", (boolean)this.finalized.isSet());
        this.transport.attachNewConnection(connection);
        return this.transport;
    }

    @Override
    public final void finalizeStack() {
        if (!this.finalized.attemptSet()) {
            throw Assert.failure((Object)"Attempt to finalize an already finalized stack");
        }
        Assert.assertNotNull((Object)this.channel);
        Assert.assertNotNull((Object)this.transportFactory);
        this.transport = this.transportFactory.createNewTransport();
        this.transport.setAllowConnectionReplace(this.allowConnectionReplace);
        this.connectStack();
    }

    protected ClientConnectionEstablisher createClientConnectionEstablisher() {
        return this.transportFactory.createClientConnectionEstablisher();
    }

    protected void connectStack() {
        final NetworkLayer last = this.chainNetworkLayers(this.transport);
        last.setReceiveLayer(this.channel);
        final ClientConnectionEstablisher cce = this.createClientConnectionEstablisher();
        this.channel.setMessageTransportInitiator(new MessageTransportInitiator(){

            @Override
            public NetworkStackID openMessageTransport(Collection<ConnectionInfo> dest, ConnectionID connection) throws CommStackMismatchException, IOException, MaxConnectionsExceededException, TCTimeoutException {
                ClientNetworkStackHarness.this.channel.setSendLayer(last);
                ClientNetworkStackHarness.this.transport.initConnectionID(connection);
                return cce.open(dest, ClientNetworkStackHarness.this.transport);
            }
        });
        MessageTransportListener watcher = this.createTransportListener(this.transport, cce);
        this.transport.addTransportListener(watcher);
    }

    protected MessageTransportListener createTransportListener(ClientMessageTransport transport, ClientConnectionEstablisher cce) {
        return new ConnectionWatcher(transport, this.channel, cce);
    }

    @Override
    public MessageTransport getTransport() {
        return this.transport;
    }

    @Override
    public MessageChannel getChannel() {
        return this.channel;
    }

    public String toString() {
        return "ClientNetworkStackHarness[ transport:" + this.transport + "channel" + this.channel + "]";
    }
}

