/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol;

import com.tc.async.api.Sink;
import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.net.core.TCConnection;
import com.tc.net.protocol.HttpConnectionContext;
import com.tc.net.protocol.TCProtocolAdaptor;
import com.tc.net.protocol.TCProtocolException;
import com.tc.util.Assert;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ProtocolSwitch
implements TCProtocolAdaptor {
    private static final String[] HTTP_METHODS = new String[]{"GET", "POST", "HEAD", "PUT", "OPTIONS", "DELETE", "TRACE", "CONNECT"};
    private static final Set<String> METHODS = new HashSet<String>(Arrays.asList(HTTP_METHODS));
    private static final int INSPECT = 8;
    private static final int PROTOCOL_UNKNOWN = 0;
    private static final int PROTOCOL_NOT_HTTP = 1;
    private static final int PROTOCOL_HTTP = 2;
    private volatile int protocol = 0;
    private final TCByteBuffer[] buffer = new TCByteBuffer[]{TCByteBufferFactory.wrap((byte[])new byte[8])};
    private final TCProtocolAdaptor delegate;
    private final Sink httpSink;

    public ProtocolSwitch(TCProtocolAdaptor delegate, Sink httpSink) {
        this.delegate = delegate;
        this.httpSink = httpSink;
    }

    public void addReadData(TCConnection source, TCByteBuffer[] data, int length) throws TCProtocolException {
        switch (this.protocol) {
            case 1: {
                this.delegate.addReadData(source, data, length);
                return;
            }
            case 0: {
                Assert.assertEquals((int)1, (int)data.length);
                TCByteBuffer buf = data[0];
                if (buf.hasRemaining()) {
                    return;
                }
                buf.flip();
                boolean isHttp = ProtocolSwitch.isHttp(buf);
                buf.rewind();
                if (isHttp) {
                    Socket socket;
                    this.protocol = 2;
                    try {
                        socket = source.detach();
                    }
                    catch (IOException e) {
                        throw new TCProtocolException((Throwable)e);
                    }
                    this.httpSink.addSingleThreaded(new HttpConnectionContext(socket, buf));
                    return;
                }
                this.protocol = 1;
                this.feedDataToDelegate(source, buf);
                return;
            }
        }
        throw new AssertionError((Object)("Protocol is " + this.protocol));
    }

    private void feedDataToDelegate(TCConnection source, TCByteBuffer src) throws TCProtocolException {
        while (src.hasRemaining()) {
            TCByteBuffer[] readBuffers;
            int count = 0;
            for (TCByteBuffer dest : readBuffers = this.delegate.getReadBuffers()) {
                int len = Math.min(src.remaining(), dest.remaining());
                count += len;
                for (int j = 0; j < len; ++j) {
                    dest.put(src.get());
                }
                if (!src.hasRemaining()) break;
            }
            this.delegate.addReadData(source, readBuffers, count);
        }
    }

    private static boolean isHttp(TCByteBuffer buf) {
        String s;
        Assert.assertEquals((int)8, (int)buf.limit());
        byte[] bytes = new byte[buf.limit()];
        buf.get(bytes);
        try {
            s = new String(bytes);
        }
        catch (Exception e) {
            return false;
        }
        int spaceIndex = s.indexOf(32);
        if (spaceIndex < 0) {
            return false;
        }
        String token = s.substring(0, spaceIndex);
        return METHODS.contains(token);
    }

    public TCByteBuffer[] getReadBuffers() {
        switch (this.protocol) {
            case 1: {
                return this.delegate.getReadBuffers();
            }
            case 0: {
                return this.buffer;
            }
        }
        throw new IllegalStateException("Unexpected protocol: " + this.protocol);
    }
}

