/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.delivery;

import com.tc.exception.TCRuntimeException;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.properties.ReconnectConfig;

public class AbstractReconnectConfig
implements ReconnectConfig {
    private final String name;
    private final boolean reconnectEnabled;
    private final int reconnectTimeout;
    private final int reconnectSendQueueCap;
    private final int reconnectMaxDelayedAcks;
    private final int reconnectSendWindow;
    private static final TCLogger logger = TCLogging.getLogger(AbstractReconnectConfig.class);

    public AbstractReconnectConfig(boolean reconnectEnabled, int reconnectTimeout, int reconnectSendQueueCap, int reconnectMaxDelayedAcks, int reconnectSendWindow, String name) {
        this.name = name;
        this.reconnectEnabled = reconnectEnabled;
        this.reconnectTimeout = reconnectTimeout;
        this.reconnectSendQueueCap = reconnectSendQueueCap;
        this.reconnectMaxDelayedAcks = reconnectMaxDelayedAcks;
        this.reconnectSendWindow = reconnectSendWindow > 0 ? reconnectSendWindow : 0;
        this.validateConfig();
    }

    private void validateConfig() {
        if (this.reconnectMaxDelayedAcks <= 0) {
            throw new TCRuntimeException(this.name + " reconnectMaxDelayedAcks should be greater than 0");
        }
        if (this.reconnectSendWindow <= 0) {
            logger.warn((Object)(this.name + " reconnectSendWindow is 0; Message Sender might not throttle for peer node respoonse"));
        }
        if (this.reconnectMaxDelayedAcks >= this.reconnectSendWindow) {
            throw new TCRuntimeException(this.name + " : reconnectMaxDelayedAcks should be lesser than reconnectSendWindow");
        }
    }

    @Override
    public boolean getReconnectEnabled() {
        return this.reconnectEnabled;
    }

    @Override
    public int getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    @Override
    public int getSendQueueCapacity() {
        return this.reconnectSendQueueCap;
    }

    @Override
    public int getMaxDelayAcks() {
        return this.reconnectMaxDelayedAcks;
    }

    @Override
    public int getSendWindow() {
        return this.reconnectSendWindow;
    }
}

