/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.protocol.tcm.ChannelEvent;
import com.tc.net.protocol.tcm.ChannelEventListener;
import com.tc.net.protocol.tcm.ChannelEventType;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.ChannelManager;
import com.tc.net.protocol.tcm.ChannelManagerEventListener;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageChannelInternal;
import com.tc.net.protocol.tcm.ServerMessageChannelFactory;
import com.tc.util.Assert;
import com.tc.util.ProductID;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

class ChannelManagerImpl
implements ChannelManager,
ChannelEventListener,
ServerMessageChannelFactory {
    private static final TCLogger logger = TCLogging.getLogger(ChannelManager.class);
    private static final MessageChannelInternal[] EMPTY_CHANNEL_ARARY = new MessageChannelInternal[0];
    private final Map<ChannelID, MessageChannelInternal> channels;
    private final boolean transportDisconnectRemovesChannel;
    private final ServerMessageChannelFactory channelFactory;
    private final List<ChannelManagerEventListener> eventListeners = new CopyOnWriteArrayList<ChannelManagerEventListener>();

    public ChannelManagerImpl(boolean transportDisconnectRemovesChannel, ServerMessageChannelFactory channelFactory) {
        this.channels = new HashMap<ChannelID, MessageChannelInternal>();
        this.transportDisconnectRemovesChannel = transportDisconnectRemovesChannel;
        this.channelFactory = channelFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageChannelInternal createNewChannel(ChannelID id, ProductID productId) {
        MessageChannelInternal channel = this.channelFactory.createNewChannel(id, productId);
        ChannelManagerImpl channelManagerImpl = this;
        synchronized (channelManagerImpl) {
            this.channels.put(channel.getChannelID(), channel);
            channel.addListener(this);
        }
        return channel;
    }

    private void fireChannelCreatedEvent(MessageChannel channel) {
        for (ChannelManagerEventListener eventListener : this.eventListeners) {
            eventListener.channelCreated(channel);
        }
    }

    private void fireChannelRemovedEvent(MessageChannel channel) {
        for (ChannelManagerEventListener eventListener : this.eventListeners) {
            eventListener.channelRemoved(channel);
        }
    }

    @Override
    public synchronized MessageChannelInternal getChannel(ChannelID id) {
        return this.channels.get(id);
    }

    @Override
    public synchronized MessageChannelInternal[] getChannels() {
        return this.channels.values().toArray(EMPTY_CHANNEL_ARARY);
    }

    @Override
    public synchronized void closeAllChannels() {
        MessageChannelInternal[] channelsCopy;
        for (MessageChannelInternal element : channelsCopy = this.getChannels()) {
            element.close();
        }
        Assert.assertEquals((int)0, (int)this.channels.size());
    }

    @Override
    public synchronized Set<ChannelID> getAllChannelIDs() {
        return new HashSet<ChannelID>(this.channels.keySet());
    }

    @Override
    public synchronized boolean isValidID(ChannelID channelID) {
        if (channelID == null) {
            return false;
        }
        MessageChannelInternal channel = this.getChannel(channelID);
        if (channel == null) {
            logger.warn((Object)("no channel found for " + channelID));
            return false;
        }
        return true;
    }

    public void notifyChannelEvent(ChannelEvent event) {
        MessageChannel channel = event.getChannel();
        if (ChannelEventType.CHANNEL_CLOSED_EVENT.matches(event)) {
            this.removeChannel(channel);
        } else if (ChannelEventType.TRANSPORT_DISCONNECTED_EVENT.matches(event)) {
            if (this.transportDisconnectRemovesChannel) {
                channel.close();
            }
        } else if (ChannelEventType.TRANSPORT_CONNECTED_EVENT.matches(event)) {
            this.fireChannelCreatedEvent(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChannel(MessageChannel channel) {
        boolean notfound;
        ChannelManagerImpl channelManagerImpl = this;
        synchronized (channelManagerImpl) {
            notfound = this.channels.remove(channel.getChannelID()) == null;
        }
        if (notfound) {
            logger.warn((Object)("Remove non-exist channel:" + channel.getChannelID()));
            return;
        }
        this.fireChannelRemovedEvent(channel);
    }

    @Override
    public synchronized void addEventListener(ChannelManagerEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must be non-null");
        }
        this.eventListeners.add(listener);
    }
}

