/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.NodeID;
import com.tc.net.StripeID;
import com.tc.net.core.ConnectionInfo;
import com.tc.net.protocol.NetworkStackID;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.tcm.AbstractMessageChannel;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.TCMessageFactory;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.JvmIDUtil;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportInitiator;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.msg.ClientHandshakeMessageFactory;
import com.tc.object.session.SessionID;
import com.tc.object.session.SessionProvider;
import com.tc.util.ProductID;
import com.tc.util.TCTimeoutException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.UnknownHostException;
import java.util.Collection;

public class ClientMessageChannelImpl
extends AbstractMessageChannel
implements ClientMessageChannel,
ClientHandshakeMessageFactory {
    private static final TCLogger logger = TCLogging.getLogger(ClientMessageChannel.class);
    private int connectAttemptCount;
    private int connectCount;
    private volatile ChannelID channelID = ChannelID.NULL_ID;
    private final SessionProvider sessionProvider;
    private MessageTransportInitiator initiator;
    private volatile SessionID channelSessionID = SessionID.NULL_ID;

    protected ClientMessageChannelImpl(TCMessageFactory msgFactory, TCMessageRouter router, SessionProvider sessionProvider, ProductID productId) {
        super(router, logger, msgFactory, (NodeID)StripeID.NULL_ID, productId);
        this.sessionProvider = sessionProvider;
        this.sessionProvider.initProvider();
    }

    @Override
    public void setMessageTransportInitiator(MessageTransportInitiator initiator) {
        this.initiator = initiator;
    }

    @Override
    public void reset() {
        AbstractMessageChannel.ChannelStatus status = this.getStatus();
        status.reset();
        this.sendLayer.reset();
    }

    public NetworkStackID open(Collection<ConnectionInfo> info) throws TCTimeoutException, UnknownHostException, IOException, MaxConnectionsExceededException, CommStackMismatchException {
        return this.open(info, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkStackID open(Collection<ConnectionInfo> info, String username, char[] pw) throws TCTimeoutException, UnknownHostException, IOException, MaxConnectionsExceededException, CommStackMismatchException {
        AbstractMessageChannel.ChannelStatus status;
        AbstractMessageChannel.ChannelStatus channelStatus = status = this.getStatus();
        synchronized (channelStatus) {
            if (status.isOpen()) {
                throw new IllegalStateException("Channel already open");
            }
            ConnectionID cid = new ConnectionID(JvmIDUtil.getJvmID(), ((ClientID)this.getLocalNodeID()).toLong(), username, pw, this.getProductId());
            NetworkStackID id = this.initiator.openMessageTransport(info, cid);
            if (id.isValid()) {
                long validID = id.toLong();
                this.channelID = new ChannelID(validID);
                this.setLocalNodeID((NodeID)new ClientID(validID));
            }
            this.channelSessionID = this.sessionProvider.getSessionID();
            this.channelOpened();
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelID getChannelID() {
        AbstractMessageChannel.ChannelStatus status;
        AbstractMessageChannel.ChannelStatus channelStatus = status = this.getStatus();
        synchronized (channelStatus) {
            if (!status.isOpen()) {
                logger.warn((Object)("Attempt to get the channel ID of an unopened channel - " + this.channelID));
            }
            return this.channelID;
        }
    }

    @Override
    public int getConnectCount() {
        return this.connectCount;
    }

    @Override
    public int getConnectAttemptCount() {
        return this.connectAttemptCount;
    }

    @Override
    public void send(TCNetworkMessage message) throws IOException {
        super.send(message);
    }

    @Override
    public void notifyTransportConnected(MessageTransport transport) {
        if (transport.getConnectionId().isValid()) {
            long channelIdLong = transport.getConnectionId().getChannelID();
            this.channelID = new ChannelID(channelIdLong);
            this.setLocalNodeID((NodeID)new ClientID(channelIdLong));
            ++this.connectCount;
        }
        super.notifyTransportConnected(transport);
    }

    @Override
    public void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
        this.channelSessionID = this.sessionProvider.nextSessionID();
        logger.info((Object)("ClientMessageChannel moves to " + this.channelSessionID + " for remote node " + this.getRemoteNodeID()));
        super.notifyTransportDisconnected(transport, forcedDisconnect);
    }

    @Override
    public void notifyTransportConnectAttempt(MessageTransport transport) {
        super.notifyTransportConnectAttempt(transport);
        ++this.connectAttemptCount;
    }

    @Override
    public void notifyTransportClosed(MessageTransport transport) {
    }

    @Override
    public ClientID getClientID() {
        return (ClientID)this.getLocalNodeID();
    }

    public ClientHandshakeMessage newClientHandshakeMessage(String uuid, String name, String clientVersion, boolean isEnterpriseClient, boolean isDiagnosticClient) {
        ClientHandshakeMessage rv = (ClientHandshakeMessage)this.createMessage(TCMessageType.CLIENT_HANDSHAKE_MESSAGE);
        rv.setClientVersion(clientVersion);
        rv.setEnterpriseClient(isEnterpriseClient);
        rv.setDiagnosticClient(isDiagnosticClient);
        rv.setClientPID(this.getPID());
        rv.setUUID(uuid);
        rv.setName(name);
        return rv;
    }

    @Override
    public ClientHandshakeMessageFactory getClientHandshakeMessageFactory() {
        return this;
    }

    private int getPID() {
        String vmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = vmName.indexOf(64);
        if (index < 0) {
            throw new RuntimeException("unexpected format: " + vmName);
        }
        return Integer.parseInt(vmName.substring(0, index));
    }
}

