/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.transport.ConnectionHealthCheckerContext;
import com.tc.net.protocol.transport.ConnectionHealthCheckerImpl;
import com.tc.net.protocol.transport.HealthCheckerProbeMessage;
import com.tc.net.protocol.transport.HealthCheckerProbeMessageFactory;
import com.tc.net.protocol.transport.MessageTransportBase;
import com.tc.net.protocol.transport.TransportMessageFactoryImpl;
import java.io.IOException;

public class ConnectionHealthCheckerContextEchoImpl
implements ConnectionHealthCheckerContext {
    private final MessageTransportBase transport;
    private final HealthCheckerProbeMessageFactory messageFactory;
    private final TCLogger logger = TCLogging.getLogger(ConnectionHealthCheckerImpl.class);

    public ConnectionHealthCheckerContextEchoImpl(MessageTransportBase mtb) {
        this.transport = mtb;
        this.messageFactory = new TransportMessageFactoryImpl();
    }

    @Override
    public boolean receiveProbe(HealthCheckerProbeMessage message) {
        if (message.isPing()) {
            HealthCheckerProbeMessage pingReplyMessage = this.messageFactory.createPingReply(this.transport.getConnectionId(), this.transport.getConnection());
            try {
                this.transport.send((TCNetworkMessage)pingReplyMessage);
            }
            catch (IOException ioe) {
                this.logger.warn((Object)"trouble ping", (Throwable)ioe);
                return false;
            }
            return true;
        }
        if (message.isTimeCheck()) {
            return true;
        }
        this.logger.info((Object)message.toString());
        throw new AssertionError((Object)"Echo HealthChecker");
    }

    @Override
    public void checkTime() {
        throw new AssertionError((Object)"Echo HealthChecker");
    }

    @Override
    public boolean probeIfAlive() {
        throw new AssertionError((Object)"Echo HealthChecker");
    }

    @Override
    public void refresh() {
        throw new AssertionError((Object)"Echo HealthChecker");
    }
}

