/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.session;

import com.tc.object.session.SessionID;
import com.tc.object.session.SessionManager;
import com.tc.util.sequence.Sequence;

public class SessionManagerImpl
implements SessionManager {
    private Provider provider;
    private final SequenceFactory sequenceFactory;

    public SessionManagerImpl(SequenceFactory sequenceFactory) {
        this.sequenceFactory = sequenceFactory;
    }

    @Override
    public boolean isCurrentSession(SessionID sessionID) {
        Provider provider = this.getProvider();
        return provider.isCurrentSession(sessionID);
    }

    @Override
    public void newSession() {
        Provider provider = this.getProvider();
        provider.newSession();
    }

    @Override
    public SessionID getSessionID() {
        Provider provider = this.getProvider();
        return provider.getSessionID();
    }

    @Override
    public SessionID nextSessionID() {
        Provider provider = this.getProvider();
        return provider.nextSessionID();
    }

    @Override
    public synchronized void initProvider() {
        if (this.provider != null) {
            throw new RuntimeException("Session provider already exists");
        }
        this.provider = new Provider(this.sequenceFactory.newSequence());
    }

    @Override
    public synchronized void resetSessionProvider() {
        this.provider = null;
    }

    private synchronized Provider getProvider() {
        return this.provider;
    }

    private static class Provider {
        private final Sequence sequence;
        private SessionID sessionID = SessionID.NULL_ID;
        private SessionID nextSessionID = SessionID.NULL_ID;

        public Provider(Sequence sequence) {
            this.sequence = sequence;
        }

        public synchronized SessionID getSessionID() {
            return this.sessionID;
        }

        public synchronized SessionID nextSessionID() {
            if (this.nextSessionID == SessionID.NULL_ID) {
                this.nextSessionID = new SessionID(this.sequence.next());
            }
            return this.nextSessionID;
        }

        public synchronized void newSession() {
            if (this.nextSessionID != SessionID.NULL_ID) {
                this.sessionID = this.nextSessionID;
                this.nextSessionID = SessionID.NULL_ID;
            } else {
                this.sessionID = new SessionID(this.sequence.next());
            }
        }

        public synchronized boolean isCurrentSession(SessionID compare) {
            return this.sessionID.equals((Object)compare);
        }

        public synchronized String toString() {
            return this.getClass().getName() + "[current session=" + this.sessionID + "]";
        }
    }

    public static interface SequenceFactory {
        public Sequence newSequence();
    }
}

