/*
 * Decompiled with CFR 0.152.
 */
package com.tc.operatorevent;

import com.tc.net.NodeID;
import com.tc.operatorevent.TerracottaOperatorEvent;
import com.tc.operatorevent.TerracottaOperatorEventImpl;
import com.tc.operatorevent.TerracottaOperatorEventResources;
import com.tc.properties.TCPropertiesImpl;
import java.text.MessageFormat;

public class TerracottaOperatorEventFactory {
    public static TerracottaOperatorEvent createLongGCOperatorEvent(Object[] arguments) {
        return new TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel.WARN, TerracottaOperatorEvent.EventSubsystem.MEMORY_MANAGER, TerracottaOperatorEvent.EventType.MEMORY_LONGGC, MessageFormat.format(TerracottaOperatorEventResources.getLongGCMessage(), arguments), "");
    }

    public static TerracottaOperatorEvent createNodeConnectedEvent(String nodeName) {
        return new TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel.INFO, TerracottaOperatorEvent.EventSubsystem.CLUSTER_TOPOLOGY, TerracottaOperatorEvent.EventType.TOPOLOGY_NODE_JOINED, MessageFormat.format(TerracottaOperatorEventResources.getNodeAvailabiltyMessage(), nodeName, "joined"), nodeName + "joined");
    }

    public static TerracottaOperatorEvent createNodeDisconnectedEvent(String nodeName) {
        return new TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel.WARN, TerracottaOperatorEvent.EventSubsystem.CLUSTER_TOPOLOGY, TerracottaOperatorEvent.EventType.TOPOLOGY_NODE_LEFT, MessageFormat.format(TerracottaOperatorEventResources.getNodeAvailabiltyMessage(), nodeName, "left"), nodeName + "left");
    }

    public static TerracottaOperatorEvent createClusterNodeStateChangedEvent(String newState) {
        return new TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel.INFO, TerracottaOperatorEvent.EventSubsystem.CLUSTER_TOPOLOGY, TerracottaOperatorEvent.EventType.TOPOLOGY_NODE_STATE, MessageFormat.format(TerracottaOperatorEventResources.getClusterNodeStateChangedMessage(), newState), "");
    }

    public static TerracottaOperatorEvent createHandShakeRejectedEvent(String clientVersion, NodeID remoteNodeID, String serverVersion) {
        return new TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel.ERROR, TerracottaOperatorEvent.EventSubsystem.CLUSTER_TOPOLOGY, TerracottaOperatorEvent.EventType.TOPOLOGY_HANDSHAKE_REJECT, MessageFormat.format(TerracottaOperatorEventResources.getHandshakeRejectedMessage(), clientVersion, remoteNodeID.toString(), serverVersion), "handshake rejected");
    }

    public static TerracottaOperatorEvent createActiveL2DisconnectedEvent(String serverName) {
        return new TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel.WARN, TerracottaOperatorEvent.EventSubsystem.CLUSTER_TOPOLOGY, TerracottaOperatorEvent.EventType.TOPOLOGY_ACTIVE_LEFT, MessageFormat.format(TerracottaOperatorEventResources.getActiveServerDisconnectMessage(), serverName), "");
    }

    public static TerracottaOperatorEvent createPassiveL2DisconnectedEvent(String serverName) {
        return new TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel.WARN, TerracottaOperatorEvent.EventSubsystem.CLUSTER_TOPOLOGY, TerracottaOperatorEvent.EventType.TOPOLOGY_MIRROR_LEFT, MessageFormat.format(TerracottaOperatorEventResources.getMirrorServerDisconnectMessage(), serverName), "");
    }

    public static TerracottaOperatorEvent createZapRequestReceivedEvent(Object[] arguments) {
        return new TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel.WARN, TerracottaOperatorEvent.EventSubsystem.CLUSTER_TOPOLOGY, TerracottaOperatorEvent.EventType.TOPOLOGY_ZAP_RECEIVED, MessageFormat.format(TerracottaOperatorEventResources.getZapRequestReceivedMessage(), arguments), "");
    }

    public static TerracottaOperatorEvent createZapRequestAcceptedEvent(Object[] arguments) {
        return new TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel.WARN, TerracottaOperatorEvent.EventSubsystem.CLUSTER_TOPOLOGY, TerracottaOperatorEvent.EventType.TOPOLOGY_ZAP_ACCEPTED, MessageFormat.format(TerracottaOperatorEventResources.getZapRequestAcceptedMessage(), arguments), "");
    }

    public static TerracottaOperatorEvent createDirtyDBEvent() {
        String restart;
        TerracottaOperatorEvent.EventLevel type;
        if (TCPropertiesImpl.getProperties().getBoolean("l2.nha.dirtydb.autoDelete")) {
            type = TerracottaOperatorEvent.EventLevel.INFO;
            restart = "enabled";
        } else {
            type = TerracottaOperatorEvent.EventLevel.ERROR;
            restart = "disabled";
        }
        return new TerracottaOperatorEventImpl(type, TerracottaOperatorEvent.EventSubsystem.CLUSTER_TOPOLOGY, TerracottaOperatorEvent.EventType.TOPOLOGY_DB_DIRTY, MessageFormat.format(TerracottaOperatorEventResources.getDirtyDBMessage(), restart), "");
    }

    public static TerracottaOperatorEvent createServerMapEvictionOperatorEvent(Object[] arguments) {
        return new TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel.INFO, TerracottaOperatorEvent.EventSubsystem.DCV2, TerracottaOperatorEvent.EventType.DCV2_SERVERMAP_EVICTION, MessageFormat.format(TerracottaOperatorEventResources.getServerMapEvictionMessage(), arguments), "");
    }

    public static TerracottaOperatorEvent createSystemTimeDifferentEvent(NodeID remoteNodeID, String desp, String serverName, long timeDiff) {
        return new TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel.WARN, TerracottaOperatorEvent.EventSubsystem.SYSTEM_SETUP, TerracottaOperatorEvent.EventType.SYSTEM_TIME_DIFFERENT, MessageFormat.format(TerracottaOperatorEventResources.getTimeDifferentMessage(), remoteNodeID, desp, serverName, timeDiff), "time difference");
    }

    public static TerracottaOperatorEvent createConfigReloadedEvent(String description) {
        return new TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel.INFO, TerracottaOperatorEvent.EventSubsystem.CLUSTER_TOPOLOGY, TerracottaOperatorEvent.EventType.TOPOLOGY_CONFIG_RELOADED, MessageFormat.format(TerracottaOperatorEventResources.getConfigReloadedMessage(), description), "config reload");
    }

    public static TerracottaOperatorEvent createNearResourceCapacityEvent(String rsrcName, long percent) {
        return new TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel.WARN, TerracottaOperatorEvent.EventSubsystem.RESOURCE, TerracottaOperatorEvent.EventType.RESOURCE_CAPACITY_NEAR, MessageFormat.format(TerracottaOperatorEventResources.getNearResourceCapacityLimit(), rsrcName, percent), "near capacity");
    }

    public static TerracottaOperatorEvent createFullResourceCapacityEvent(String rsrcName, long percent) {
        return new TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel.ERROR, TerracottaOperatorEvent.EventSubsystem.RESOURCE, TerracottaOperatorEvent.EventType.RESOURCE_CAPACITY_FULL, MessageFormat.format(TerracottaOperatorEventResources.getFullResourceCapacityLimit(), rsrcName, percent), "full capacity");
    }

    public static TerracottaOperatorEvent createNormalResourceCapacityEvent(String rsrcName, long percent) {
        return new TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel.INFO, TerracottaOperatorEvent.EventSubsystem.RESOURCE, TerracottaOperatorEvent.EventType.RESOURCE_CAPACITY_RESTORED, MessageFormat.format(TerracottaOperatorEventResources.getRestoredNormalResourceCapacity(), rsrcName, percent), "normal capacity restored");
    }
}

