/*
 * Decompiled with CFR 0.152.
 */
package com.tc.operatorevent;

import com.tc.operatorevent.TerracottaOperatorEvent;
import com.tc.util.Assert;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TerracottaOperatorEventImpl
implements TerracottaOperatorEvent,
Comparable<TerracottaOperatorEventImpl> {
    private final long time;
    private final String eventMessage;
    private final TerracottaOperatorEvent.EventLevel eventLevel;
    private final TerracottaOperatorEvent.EventType eventType;
    private final TerracottaOperatorEvent.EventSubsystem subSystem;
    private volatile Map<String, Integer> nodes;
    private boolean isRead = false;
    private final String collapseString;

    public TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel eventLevel, TerracottaOperatorEvent.EventSubsystem subSystem, TerracottaOperatorEvent.EventType eventType, String message, String collapseString) {
        this(eventLevel, subSystem, eventType, System.currentTimeMillis(), message, collapseString, new HashMap<String, Integer>());
    }

    public TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel eventLevel, TerracottaOperatorEvent.EventSubsystem subSystem, TerracottaOperatorEvent.EventType eventType, String message, long time, String collapseString) {
        this(eventLevel, subSystem, eventType, time, message, collapseString, new HashMap<String, Integer>());
    }

    private TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel eventLevel, TerracottaOperatorEvent.EventSubsystem subsystem, TerracottaOperatorEvent.EventType eventType, long time, String message, String collapseString, Map<String, Integer> nodes) {
        if (nodes instanceof ConcurrentHashMap) {
            throw new AssertionError((Object)"CHM not allowed here");
        }
        this.eventLevel = eventLevel;
        this.subSystem = subsystem;
        this.time = time;
        this.eventMessage = message;
        this.collapseString = collapseString;
        this.nodes = nodes;
        this.eventType = eventType;
    }

    @Override
    public String getEventMessage() {
        return this.eventMessage;
    }

    @Override
    public Date getEventTime() {
        return new Date(this.time);
    }

    @Override
    public TerracottaOperatorEvent.EventLevel getEventLevel() {
        return this.eventLevel;
    }

    @Override
    public String getEventLevelAsString() {
        return this.eventLevel.name();
    }

    @Override
    public TerracottaOperatorEvent.EventType getEventType() {
        return this.eventType;
    }

    @Override
    public String getEventTypeAsString() {
        return this.eventType.name();
    }

    @Override
    public synchronized String getNodeName() {
        StringBuilder val = new StringBuilder();
        for (Map.Entry<String, Integer> node : this.nodes.entrySet()) {
            Assert.assertTrue((node.getValue() >= 1 ? 1 : 0) != 0);
            val.append(node.getKey());
            if (node.getValue() > 1) {
                val.append("(").append(node.getValue()).append(")");
            }
            val.append(" ");
        }
        return val.toString().trim();
    }

    @Override
    public synchronized void addNodeName(String nodeId) {
        Integer numOfSuchEvents = this.nodes.get(nodeId);
        if (numOfSuchEvents == null) {
            this.nodes.put(nodeId, 1);
        } else {
            this.nodes.put(nodeId, numOfSuchEvents + 1);
        }
    }

    @Override
    public TerracottaOperatorEvent.EventSubsystem getEventSubsystem() {
        return this.subSystem;
    }

    @Override
    public String getEventSubsystemAsString() {
        return this.subSystem.name();
    }

    @Override
    public String getCollapseString() {
        return this.collapseString;
    }

    @Override
    public int compareTo(TerracottaOperatorEventImpl o) {
        return (int)(this.time - o.time);
    }

    @Override
    public boolean isRead() {
        return this.isRead;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TerracottaOperatorEventImpl)) {
            return false;
        }
        TerracottaOperatorEventImpl event = (TerracottaOperatorEventImpl)o;
        if (this.eventLevel != event.eventLevel) {
            return false;
        }
        if (this.subSystem != event.subSystem) {
            return false;
        }
        if (this.eventType != event.eventType) {
            return false;
        }
        if (this.time != event.time) {
            return false;
        }
        return this.collapseString.equals(event.collapseString);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collapseString == null ? 0 : this.collapseString.hashCode());
        result = 31 * result + (this.eventLevel == null ? 0 : this.eventLevel.hashCode());
        result = 31 * result + (this.subSystem == null ? 0 : this.subSystem.hashCode());
        result = 31 * result + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        return result;
    }

    @Override
    public void markRead() {
        this.isRead = true;
    }

    @Override
    public void markUnread() {
        this.isRead = false;
    }

    public String toString() {
        return (Object)((Object)this.getEventLevel()) + " " + this.getEventTime() + " " + this.getNodeName() + " " + this.getEventSubsystemAsString() + " " + this.getEventTypeAsString() + " " + this.getEventMessage();
    }

    @Override
    public String extractAsText() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerracottaOperatorEvent cloneEvent() {
        HashMap<String, Integer> nodesCopy;
        TerracottaOperatorEventImpl terracottaOperatorEventImpl = this;
        synchronized (terracottaOperatorEventImpl) {
            nodesCopy = new HashMap<String, Integer>(this.nodes);
        }
        return new TerracottaOperatorEventImpl(this.eventLevel, this.subSystem, this.eventType, this.time, this.eventMessage, this.collapseString, nodesCopy);
    }

    public Map<String, Integer> getNodes() {
        return this.nodes;
    }
}

