/*
 * Decompiled with CFR 0.152.
 */
package com.tc.runtime;

import com.tc.exception.TCRuntimeException;
import com.tc.lang.TCThreadGroup;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.runtime.JVMMemoryManager;
import com.tc.runtime.MemoryEventsListener;
import com.tc.runtime.MemoryUsage;
import com.tc.runtime.TCMemoryManager;
import com.tc.runtime.TCRuntime;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class TCMemoryManagerImpl
implements TCMemoryManager {
    private static final TCLogger logger = TCLogging.getLogger(TCMemoryManagerImpl.class);
    private static final String CMS_NAME = "ConcurrentMarkSweep";
    private static final String CMS_WARN_MESG = "Terracotta does not recommend ConcurrentMarkSweep Collector.";
    private final List<MemoryEventsListener> listeners = new CopyOnWriteArrayList<MemoryEventsListener>();
    private final int leastCount;
    private final long sleepInterval;
    private MemoryMonitor monitor;
    private final TCThreadGroup threadGroup;

    public TCMemoryManagerImpl(long sleepInterval, int leastCount, TCThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
        this.sleepInterval = sleepInterval;
        this.leastCount = leastCount;
    }

    public TCMemoryManagerImpl(TCThreadGroup threadGroup) {
        this(3000L, 2, threadGroup);
    }

    @Override
    public void checkGarbageCollectors() {
        List<GarbageCollectorMXBean> gcmbeans = ManagementFactory.getGarbageCollectorMXBeans();
        boolean foundCMS = false;
        for (GarbageCollectorMXBean mbean : gcmbeans) {
            String gcname = mbean.getName();
            logger.info((Object)("GarbageCollector: " + gcname));
            if (!CMS_NAME.equals(gcname)) continue;
            foundCMS = true;
        }
        if (foundCMS) {
            logger.warn((Object)CMS_WARN_MESG);
        }
    }

    @Override
    public void registerForMemoryEvents(MemoryEventsListener listener) {
        this.listeners.add(listener);
        this.startMonitorIfNecessary();
    }

    @Override
    public void unregisterForMemoryEvents(MemoryEventsListener listener) {
        this.listeners.remove(listener);
        this.stopMonitorIfNecessary();
    }

    private synchronized void stopMonitorIfNecessary() {
        if (this.listeners.size() == 0) {
            this.stopMonitorThread();
        }
    }

    private void stopMonitorThread() {
        if (this.monitor != null) {
            this.monitor.stopMonitoring();
            try {
                this.monitor.join();
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
    }

    private synchronized void startMonitorIfNecessary() {
        if (this.listeners.size() > 0 && this.monitor == null) {
            this.monitor = new MemoryMonitor(TCRuntime.getJVMMemoryManager(), this.sleepInterval);
            this.monitor.start();
        }
    }

    private void fireMemoryEvent(MemoryUsage mu) {
        for (MemoryEventsListener listener : this.listeners) {
            listener.memoryUsed(mu);
        }
    }

    @Override
    public synchronized void shutdown() {
        this.stopMonitorThread();
    }

    public class MemoryMonitor
    extends Thread {
        private final JVMMemoryManager manager;
        private volatile boolean run;
        private int lastUsed;
        private long sleepTime;

        public MemoryMonitor(JVMMemoryManager manager, long sleepInterval) {
            super((ThreadGroup)TCMemoryManagerImpl.this.threadGroup, "TC Memory Monitor");
            this.run = true;
            this.manager = manager;
            this.sleepTime = sleepInterval;
        }

        private void stopMonitoring() {
            this.run = false;
            this.interrupt();
        }

        @Override
        public void run() {
            logger.debug((Object)("Starting Memory Monitor - sleep interval - " + this.sleepTime));
            boolean interrupt = false;
            while (this.run) {
                try {
                    Thread.sleep(this.sleepTime);
                    MemoryUsage mu = this.manager.isMemoryPoolMonitoringSupported() ? this.manager.getOldGenUsage() : this.manager.getMemoryUsage();
                    TCMemoryManagerImpl.this.fireMemoryEvent(mu);
                    this.adjust(mu);
                }
                catch (InterruptedException ie) {
                    if (!this.run) continue;
                    interrupt = true;
                }
                catch (Throwable t) {
                    StackTraceElement[] trace;
                    for (StackTraceElement element : trace = t.getStackTrace()) {
                        logger.warn((Object)element.toString());
                    }
                    logger.error((Object)t);
                    throw new TCRuntimeException(t);
                }
            }
            if (interrupt) {
                this.interrupt();
            }
            logger.debug((Object)("Stopping Memory Monitor - sleep interval - " + this.sleepTime));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void adjust(MemoryUsage mu) {
            int usedPercentage = mu.getUsedPercentage();
            try {
                if (this.lastUsed != 0 && this.lastUsed < usedPercentage) {
                    int diff = usedPercentage - this.lastUsed;
                    long l_sleep = this.sleepTime;
                    if ((double)diff > (double)TCMemoryManagerImpl.this.leastCount * 1.5 && l_sleep > 1L) {
                        this.sleepTime = Math.max(1L, l_sleep * (long)TCMemoryManagerImpl.this.leastCount / (long)diff);
                        logger.info((Object)("Sleep time changed to : " + this.sleepTime));
                    } else if ((double)diff < (double)TCMemoryManagerImpl.this.leastCount * 0.5 && l_sleep < TCMemoryManagerImpl.this.sleepInterval) {
                        this.sleepTime = Math.min(TCMemoryManagerImpl.this.sleepInterval, l_sleep * (long)TCMemoryManagerImpl.this.leastCount / (long)diff);
                        logger.info((Object)("Sleep time changed to : " + this.sleepTime));
                    }
                }
            }
            finally {
                this.lastUsed = usedPercentage;
            }
        }
    }
}

