/*
 * Decompiled with CFR 0.152.
 */
package com.tc.runtime.logging;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.operatorevent.TerracottaOperatorEvent;
import com.tc.operatorevent.TerracottaOperatorEventFactory;
import com.tc.runtime.MemoryEventsListener;
import com.tc.runtime.MemoryUsage;

public class LongGCLogger
implements MemoryEventsListener {
    private static final TCLogger logger = TCLogging.getLogger(LongGCLogger.class);
    private final long gcTimeout;
    private MemoryUsage lastMemoryUsage;

    public LongGCLogger(long gcTimeOut) {
        this.gcTimeout = gcTimeOut;
    }

    @Override
    public void memoryUsed(MemoryUsage currentUsage) {
        if (this.lastMemoryUsage == null) {
            this.lastMemoryUsage = currentUsage;
            return;
        }
        long countDiff = currentUsage.getCollectionCount() - this.lastMemoryUsage.getCollectionCount();
        long timeDiff = currentUsage.getCollectionTime() - this.lastMemoryUsage.getCollectionTime();
        if (countDiff > 0L && timeDiff > this.gcTimeout) {
            TerracottaOperatorEvent tcEvent = TerracottaOperatorEventFactory.createLongGCOperatorEvent(new Object[]{this.gcTimeout, countDiff, timeDiff});
            this.fireLongGCEvent(tcEvent);
        }
        this.lastMemoryUsage = currentUsage;
    }

    protected void fireLongGCEvent(TerracottaOperatorEvent tcEvent) {
        logger.warn((Object)tcEvent.getEventMessage());
    }
}

