/*
 * Decompiled with CFR 0.152.
 */
package com.tc.statistics.util;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.properties.TCPropertiesImpl;
import com.tc.statistics.util.StatsRecorder;
import com.tc.util.concurrent.ThreadUtil;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

public final class StatsPrinter
implements StatsRecorder,
Runnable {
    private static final Aggregator aggregator = new Aggregator();
    private static final TCLogger statsLogger = TCLogging.getLogger(StatsPrinter.class);
    private final long timeInterval;
    private final ConcurrentMap<String, StatsRecord> statsRecords = new ConcurrentHashMap<String, StatsRecord>();
    private final MessageFormat formatLine;
    private final String header;
    private volatile int keyMaxSize = 0;
    private boolean printHeader;
    private final boolean printTotal;
    private volatile boolean finished = false;

    public StatsPrinter(String name, long timeInterval, MessageFormat header, MessageFormat formatLine, boolean printTotal) {
        this.printTotal = printTotal;
        this.timeInterval = timeInterval;
        this.header = header.format(new Long[]{timeInterval});
        this.formatLine = formatLine;
        Thread t = new Thread((Runnable)this, name);
        t.setDaemon(true);
        t.start();
    }

    public StatsPrinter(MessageFormat header, MessageFormat formatLine, boolean printTotal) {
        this.printTotal = printTotal;
        this.timeInterval = -1L;
        this.header = header.format(new Long[]{Aggregator.timeInterval});
        this.formatLine = formatLine;
        aggregator.addStatsPrinter(this);
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    private boolean isFinished() {
        return this.finished;
    }

    @Override
    public void updateStats(String key, long[] counters) {
        StatsRecord r = this.get(key);
        r.update(counters);
    }

    private StatsRecord get(String key) {
        StatsRecord r = (StatsRecord)this.statsRecords.get(key);
        if (r == null) {
            r = new StatsRecord(key);
            StatsRecord old = this.statsRecords.putIfAbsent(key, r);
            if (old != null) {
                r = old;
            }
            this.updateKeyMaxSize(key.length());
        }
        return r;
    }

    private void updateKeyMaxSize(int length) {
        if (this.keyMaxSize < length) {
            this.keyMaxSize = length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void print() {
        this.printHeader = true;
        StatsRecord total = new StatsRecord("TOTAL");
        TCLogger tCLogger = statsLogger;
        synchronized (tCLogger) {
            for (StatsRecord sr : this.statsRecords.values()) {
                this.printDetailsIfNecessary(sr, total);
            }
            if (this.printTotal) {
                this.printDetailsIfNecessary(total, null);
            }
        }
    }

    @Override
    public void run() {
        while (!this.isFinished()) {
            ThreadUtil.reallySleep(this.timeInterval);
            if (this.isFinished()) {
                return;
            }
            this.print();
        }
    }

    public void printDetailsIfNecessary(StatsRecord toPrint, StatsRecord total) {
        long[] counters = toPrint.getAllAndReset();
        if (counters.length != 0 && counters[0] != 0L) {
            if (this.printHeader) {
                statsLogger.info((Object)this.header);
                statsLogger.info((Object)"==========================================================");
                this.printHeader = false;
            }
            statsLogger.info((Object)this.createLogString(toPrint.getKey(), counters));
            if (total != null) {
                total.update(counters);
            }
        }
    }

    private String createLogString(String name, long[] counters) {
        StringBuffer sb = new StringBuffer();
        StatsPrinter.appendFixedSpaceString(sb, name, this.keyMaxSize + 1);
        sb.append(": ");
        return this.formatLine.format(this.toObjectArray(counters), sb, new FieldPosition(0)).toString();
    }

    private Object[] toObjectArray(long[] counters) {
        Object[] ret = new Object[counters.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = StatsPrinter.appendFixedSpaceString(new StringBuffer(), String.valueOf(counters[i]), 8);
        }
        return ret;
    }

    private static StringBuffer appendFixedSpaceString(StringBuffer sb, String msg, int length) {
        int spaces = Math.max(length - msg.length(), 0);
        sb.append(msg);
        while (spaces-- > 0) {
            sb.append(' ');
        }
        return sb;
    }

    private static class Aggregator
    implements Runnable {
        private final List<StatsPrinter> printers = new ArrayList<StatsPrinter>();
        public static long timeInterval = TCPropertiesImpl.getProperties().getLong("stats.printer.intervalInMillis");
        private Thread thread;

        private Aggregator() {
        }

        void addStatsPrinter(StatsPrinter printer) {
            this.printers.add(printer);
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new Thread((Runnable)this, "Stats Printer Aggregator");
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }

        @Override
        public void run() {
            block0: while (this.printers.size() != 0) {
                ThreadUtil.reallySleep(timeInterval);
                Iterator<StatsPrinter> iter = this.printers.iterator();
                while (true) {
                    if (!iter.hasNext()) continue block0;
                    StatsPrinter printer = iter.next();
                    if (printer.isFinished()) {
                        iter.remove();
                        continue;
                    }
                    printer.print();
                }
                break;
            }
            return;
        }
    }

    private static final class StatsRecord {
        private final String key;
        private final CopyOnWriteArrayList<AtomicLong> counterList = new CopyOnWriteArrayList();

        public StatsRecord(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void update(long[] counters) {
            if (counters.length > this.counterList.size()) {
                this.initCounters(counters.length);
            }
            for (int i = 0; i < counters.length; ++i) {
                this.counterList.get(i).addAndGet(counters[i]);
            }
        }

        private void initCounters(int num) {
            while (this.counterList.size() < num) {
                this.counterList.add(new AtomicLong(0L));
            }
        }

        public long[] getAllAndReset() {
            long[] ret = new long[this.counterList.size()];
            int size = this.counterList.size();
            for (int idx = 0; idx < size; ++idx) {
                ret[idx] = this.counterList.get(idx).getAndSet(0L);
            }
            return ret;
        }
    }
}

