/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.object.ObjectID;
import com.tc.util.AATreeSet;
import com.tc.util.FindbugsSuppressWarnings;
import com.tc.util.ObjectIDSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ExpandingBitSetObjectIDSet
extends ObjectIDSet {
    private int size;
    private final AATreeSet<BitSet> ranges = new AATreeSet();
    private volatile int modCount;

    public ExpandingBitSetObjectIDSet(Collection<ObjectID> c) {
        this.addAll(c);
    }

    public ExpandingBitSetObjectIDSet() {
    }

    @FindbugsSuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    public boolean add(ObjectID id) {
        long lid = id.toLong();
        BitSet probe = new BitSet(lid);
        BitSet prev = this.ranges.find(probe);
        if (prev != null) {
            boolean isAdded = prev.add(lid);
            if (isAdded) {
                ++this.size;
                ++this.modCount;
            }
            return isAdded;
        }
        BitSet left = this.ranges.find(probe.leftNeighbor());
        BitSet right = this.ranges.find(probe.rightNeighbor());
        if (left != null && left.merge(probe)) {
            if (right != null && left.merge(right)) {
                this.ranges.remove(right);
            }
            ++this.size;
            ++this.modCount;
            return true;
        }
        if (right != null && probe.merge(right)) {
            this.ranges.remove(right);
            this.ranges.add(probe);
            ++this.size;
            ++this.modCount;
            return true;
        }
        boolean isAdded = this.ranges.add(probe);
        if (isAdded) {
            ++this.size;
            ++this.modCount;
        }
        return isAdded;
    }

    @FindbugsSuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    public boolean remove(Object o) {
        if (!(o instanceof ObjectID)) {
            return false;
        }
        ObjectID id = (ObjectID)o;
        long lid = id.toLong();
        BitSet current = this.ranges.find(new BitSet(lid));
        if (current == null) {
            return false;
        }
        if (current.remove(lid)) {
            BitSet split = current.split(lid);
            if (split != null) {
                this.ranges.add(split);
            }
            if (current.isEmpty()) {
                this.ranges.remove(current);
            }
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    public boolean contains(Object o) {
        if (!(o instanceof ObjectID)) {
            return false;
        }
        ObjectID id = (ObjectID)o;
        long lid = id.toLong();
        BitSet r = this.ranges.find(new BitSet(lid));
        return r != null && r.contains(lid);
    }

    public Iterator<ObjectID> iterator() {
        return new ObjectIDSetIterator();
    }

    public ObjectID first() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        BitSet min = (BitSet)this.ranges.first();
        return new ObjectID(min.first());
    }

    public ObjectID last() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        BitSet max = (BitSet)this.ranges.last();
        return new ObjectID(max.last());
    }

    protected void insertRange(ObjectIDSet.Range range) {
        BitSet bitSet = new BitSet(range.getStart(), range.getBitmap());
        if (!bitSet.isEmpty()) {
            this.size = (int)((long)this.size + bitSet.size());
            this.ranges.add(bitSet);
        }
    }

    protected Collection<? extends ObjectIDSet.Range> ranges() {
        return this.ranges;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ExpandingBitSetObjectIDSet{");
        sb.append("size=").append(this.size);
        sb.append(", ranges=").append(this.ranges);
        sb.append(", modCount=").append(this.modCount);
        sb.append('}');
        return sb.toString();
    }

    static final class BitSet
    extends AATreeSet.AbstractTreeNode<BitSet>
    implements Comparable<BitSet>,
    TCSerializable<BitSet>,
    Iterable<Long>,
    ObjectIDSet.Range {
        private static final int MIN_SIZE = 16;
        private static final int MAX_SIZE = 8192;
        private static final int SPLIT_THRESHOLD = 16;
        private long start;
        private long[] nextLongs;

        BitSet(long initial) {
            this.start = initial & 0xFFFFFFFFFFFFFC00L;
            this.nextLongs = new long[16];
            this.add(initial);
        }

        BitSet(long start, long[] nextRanges) {
            this.start = start;
            this.nextLongs = nextRanges;
        }

        BitSet(BitSet copyThis) {
            this(copyThis.start, Arrays.copyOf(copyThis.nextLongs, copyThis.nextLongs.length));
        }

        public void serializeTo(TCByteBufferOutput serialOutput) {
            serialOutput.writeLong(this.start);
            serialOutput.writeInt(this.nextLongs.length);
            for (long l : this.nextLongs) {
                serialOutput.writeLong(l);
            }
        }

        public BitSet deserializeFrom(TCByteBufferInput serialInput) throws IOException {
            this.start = serialInput.readLong();
            this.nextLongs = new long[serialInput.readInt()];
            for (int i = 0; i < this.nextLongs.length; ++i) {
                this.nextLongs[i] = serialInput.readLong();
            }
            return this;
        }

        public void addAll(BitSet other) {
            if (this.start != other.start) {
                throw new AssertionError((Object)("Ranges : Start is not the same. mine : " + this.start + " other : " + other.start));
            }
            if (this.nextLongs.length != other.nextLongs.length) {
                for (int i = 0; i < this.nextLongs.length; ++i) {
                    int n = i;
                    this.nextLongs[n] = this.nextLongs[n] | other.nextLongs[i];
                }
            }
        }

        boolean merge(BitSet right) {
            if (this.max() + 1L != right.start) {
                throw new IllegalArgumentException();
            }
            if (this.nextLongs.length + right.nextLongs.length >= 8192) {
                return false;
            }
            long[] newNextLongs = new long[this.nextLongs.length + right.nextLongs.length];
            System.arraycopy(this.nextLongs, 0, newNextLongs, 0, this.nextLongs.length);
            System.arraycopy(right.nextLongs, 0, newNextLongs, this.nextLongs.length, right.nextLongs.length);
            this.nextLongs = newNextLongs;
            return true;
        }

        BitSet split(long hint) {
            BitSet split = null;
            if (!this.isEmpty() && this.nextLongs[this.arrayIndex(hint)] == 0L) {
                int right;
                int left;
                for (left = this.arrayIndex(hint); left > 0 && this.nextLongs[left] == 0L; --left) {
                }
                left += 16 - (left + 1) % 16;
                for (right = this.arrayIndex(hint); right < this.nextLongs.length && this.nextLongs[right] == 0L; ++right) {
                }
                if ((right -= right % 16) - left >= 16) {
                    if (right < this.nextLongs.length) {
                        long splitStart = this.start + (long)(right * 64);
                        long[] splitLongs = new long[this.nextLongs.length - right];
                        System.arraycopy(this.nextLongs, right, splitLongs, 0, splitLongs.length);
                        split = new BitSet(splitStart, splitLongs);
                        if (split.isEmpty()) {
                            throw new AssertionError();
                        }
                    }
                    long[] temp = new long[left + 1];
                    System.arraycopy(this.nextLongs, 0, temp, 0, temp.length);
                    this.nextLongs = temp;
                }
            }
            return split;
        }

        int capacity() {
            return this.nextLongs.length * 64;
        }

        BitSet leftNeighbor() {
            return new BitSet(this.start - 1L);
        }

        BitSet rightNeighbor() {
            return new BitSet(this.max() + 1L);
        }

        public String toString() {
            return "Range(" + this.start + "," + Arrays.toString(this.nextLongs) + ")";
        }

        public boolean isEmpty() {
            for (long l : this.nextLongs) {
                if (l == 0L) continue;
                return false;
            }
            return true;
        }

        boolean contains(long lid) {
            if (lid < this.start || lid > this.start + (long)(this.nextLongs.length * 64)) {
                return false;
            }
            return (this.nextLongs[this.arrayIndex(lid)] & this.maskBit(lid)) != 0L;
        }

        public long size() {
            long size = 0L;
            for (long l : this.nextLongs) {
                size += (long)Long.bitCount(l);
            }
            return size;
        }

        public boolean remove(long lid) {
            if (lid < this.start || lid >= this.start + (long)(this.nextLongs.length * 64)) {
                throw new AssertionError((Object)("Ranges : Illegal value passed to remove : " + this + " remove called for : " + lid));
            }
            int arrayOffset = this.arrayIndex(lid);
            long maskBit = this.maskBit(lid) & this.nextLongs[arrayOffset];
            int n = arrayOffset;
            this.nextLongs[n] = this.nextLongs[n] ^ maskBit;
            return maskBit != 0L;
        }

        public boolean add(long lid) {
            long maskBit;
            if (lid < this.start || lid >= this.start + (long)(this.nextLongs.length * 64)) {
                throw new AssertionError((Object)("Ranges : Illegal value passed to add : " + this + " add called for : " + lid));
            }
            int arrayIndex = this.arrayIndex(lid);
            if ((this.nextLongs[arrayIndex] & (maskBit = this.maskBit(lid))) == 0L) {
                int n = arrayIndex;
                this.nextLongs[n] = this.nextLongs[n] | maskBit;
                return true;
            }
            return false;
        }

        private int offset(long lid) {
            return (int)(lid - this.start);
        }

        private int arrayIndex(long lid) {
            return this.offset(lid) >> Long.numberOfTrailingZeros(64L);
        }

        private long maskBit(long lid) {
            return 1L << (this.offset(lid) & 0x3F);
        }

        @Override
        public int compareTo(BitSet o) {
            if (this.start <= o.start) {
                if (this.max() >= o.max()) {
                    return 0;
                }
                return -1;
            }
            return 1;
        }

        private long max() {
            return this.start + (long)(this.nextLongs.length * 64) - 1L;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BitSet)) {
                return false;
            }
            BitSet o = (BitSet)obj;
            return this.start == o.start && Arrays.equals(this.nextLongs, o.nextLongs);
        }

        public int hashCode() {
            return (int)(this.start * 31L + (long)Arrays.hashCode(this.nextLongs));
        }

        @Override
        public void swapPayload(AATreeSet.Node<BitSet> other) {
            if (!(other instanceof BitSet)) {
                throw new AssertionError((Object)("AATree can't contain both Ranges and other types : " + this + " other : " + other));
            }
            BitSet r = (BitSet)other;
            long temp = this.start;
            this.start = r.start;
            r.start = temp;
            long[] nextLongsTemp = this.nextLongs;
            this.nextLongs = r.nextLongs;
            r.nextLongs = nextLongsTemp;
        }

        @Override
        public BitSet getPayload() {
            return this;
        }

        public long first() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            long first = this.start;
            for (long l : this.nextLongs) {
                if (l != 0L) {
                    return first + (long)Long.numberOfTrailingZeros(l);
                }
                first += 64L;
            }
            throw new AssertionError();
        }

        public long last() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            long last = this.max();
            for (int i = this.nextLongs.length - 1; i >= 0; --i) {
                if (this.nextLongs[i] != 0L) {
                    return last - (long)Long.numberOfLeadingZeros(this.nextLongs[i]);
                }
                last -= 64L;
            }
            throw new AssertionError();
        }

        @Override
        public Iterator<Long> iterator() {
            return new BitSetIterator();
        }

        public long getStart() {
            return this.start;
        }

        public long[] getBitmap() {
            return this.nextLongs;
        }

        private class BitSetIterator
        implements Iterator<Long> {
            long prev;
            long next;

            BitSetIterator() {
                this.prev = BitSet.this.max() + 1L;
                this.next = BitSet.this.start - 1L;
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.next <= BitSet.this.max();
            }

            @Override
            public Long next() {
                if (this.next > BitSet.this.max()) {
                    throw new NoSuchElementException();
                }
                this.prev = this.next;
                this.advance();
                return this.prev;
            }

            private void advance() {
                while (++this.next <= BitSet.this.max() && !BitSet.this.contains(this.next)) {
                }
            }

            @Override
            public void remove() {
                if (this.prev > BitSet.this.max() || this.prev < BitSet.this.start || !BitSet.this.remove(this.prev)) {
                    throw new NoSuchElementException();
                }
            }
        }
    }

    private class ObjectIDSetIterator
    implements Iterator<ObjectID> {
        private Iterator<BitSet> nodes;
        private Iterator<Long> currentIterator;
        private BitSet current;
        private Iterator<Long> lastReturnedIterator;
        private BitSet lastReturnedBitSet;
        private long lastReturnedValue;
        private int expectedModCount;

        public ObjectIDSetIterator() {
            this.nodes = ExpandingBitSetObjectIDSet.this.ranges.iterator();
            this.expectedModCount = ExpandingBitSetObjectIDSet.this.modCount;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            this.checkModCount();
            this.advance();
            return this.currentIterator != null && this.currentIterator.hasNext();
        }

        private void advance() {
            if ((this.currentIterator == null || !this.currentIterator.hasNext()) && this.nodes.hasNext()) {
                BitSet bitSet = this.nodes.next();
                if (bitSet.isEmpty()) {
                    throw new AssertionError();
                }
                this.current = bitSet;
                this.currentIterator = this.current.iterator();
            }
        }

        @Override
        public ObjectID next() {
            this.checkModCount();
            this.advance();
            this.lastReturnedIterator = this.currentIterator;
            this.lastReturnedBitSet = this.current;
            this.lastReturnedValue = this.currentIterator.next();
            return new ObjectID(this.lastReturnedValue);
        }

        @Override
        @FindbugsSuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
        public void remove() {
            if (this.lastReturnedIterator == null) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            this.lastReturnedIterator.remove();
            ExpandingBitSetObjectIDSet.this.size--;
            ExpandingBitSetObjectIDSet.this.modCount++;
            BitSet split = this.lastReturnedBitSet.split(this.lastReturnedValue);
            if (split != null) {
                if (!ExpandingBitSetObjectIDSet.this.ranges.add(split)) {
                    throw new AssertionError();
                }
                if (this.lastReturnedBitSet.isEmpty() && !ExpandingBitSetObjectIDSet.this.ranges.remove(this.lastReturnedBitSet)) {
                    throw new RuntimeException();
                }
                this.nodes = ExpandingBitSetObjectIDSet.this.ranges.tailSet(split).iterator();
                this.current = null;
                this.currentIterator = null;
            } else if (this.lastReturnedBitSet.isEmpty()) {
                if (!ExpandingBitSetObjectIDSet.this.ranges.remove(this.lastReturnedBitSet)) {
                    throw new RuntimeException();
                }
                this.nodes = ExpandingBitSetObjectIDSet.this.ranges.tailSet(this.lastReturnedBitSet).iterator();
                this.current = null;
                this.currentIterator = null;
            }
            this.expectedModCount = ExpandingBitSetObjectIDSet.this.modCount;
        }

        private void checkModCount() {
            if (this.expectedModCount != ExpandingBitSetObjectIDSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

