/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.text.StringUtils;
import com.tc.util.Assert;
import com.tc.util.ResourceBundleHelper;
import com.tc.util.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ProductInfo {
    public static final String ENTERPRISE = "Enterprise";
    public static final String OPENSOURCE = "Opensource";
    private static final ResourceBundleHelper bundleHelper = new ResourceBundleHelper(ProductInfo.class);
    private static final String DATE_FORMAT = "yyyyMMdd-HHmmss";
    private static final Pattern KITIDPATTERN = Pattern.compile("(\\d+\\.\\d+.\\d+).*");
    private static final String BUILD_DATA_RESOURCE_NAME = "/build-data.txt";
    private static final String PATCH_DATA_RESOURCE_NAME = "/patch-data.txt";
    private static final String BUILD_DATA_ROOT_KEY = "terracotta.build.";
    private static final String BUILD_DATA_VERSION_KEY = "version";
    private static final String BUILD_DATA_TIMESTAMP_KEY = "timestamp";
    private static final String BUILD_DATA_REVISION_KEY = "revision";
    private static final String BUILD_DATA_BRANCH_KEY = "branch";
    private static final String PATCH_DATA_ROOT_KEY = "terracotta.patch.";
    private static final String PATCH_DATA_LEVEL_KEY = "level";
    public static final String UNKNOWN_VALUE = "[unknown]";
    public static final String DEFAULT_LICENSE = "Unlimited development";
    private static ProductInfo INSTANCE = null;
    private final String moniker;
    private final String timestamp;
    private final String branch;
    private final String edition;
    private final String revision;
    private final String kitID;
    private final String patchLevel;
    private final String patchTimestamp;
    private final String patchRevision;
    private final String patchBranch;
    private final String buildVersion;
    private String buildID;
    private String copyright;
    private final String license = "Unlimited development";

    ProductInfo(InputStream buildData, InputStream patchData) throws IOException {
        Assert.assertNotNull((Object)"buildData", (Object)buildData);
        Properties properties = new Properties();
        this.moniker = bundleHelper.getString("moniker");
        properties.load(buildData);
        if (patchData != null) {
            properties.load(patchData);
        }
        this.buildVersion = this.getBuildProperty(properties, BUILD_DATA_VERSION_KEY, UNKNOWN_VALUE);
        this.edition = ProductInfo.detectEdition();
        if (!(this.isOpenSource() || this.isEnterprise() || this.isDevMode())) {
            throw new AssertionError((Object)("Can't recognize kit edition: " + this.edition));
        }
        this.timestamp = this.getBuildProperty(properties, BUILD_DATA_TIMESTAMP_KEY, UNKNOWN_VALUE);
        this.branch = this.getBuildProperty(properties, BUILD_DATA_BRANCH_KEY, UNKNOWN_VALUE);
        this.revision = this.getBuildProperty(properties, BUILD_DATA_REVISION_KEY, UNKNOWN_VALUE);
        this.patchLevel = this.getPatchProperty(properties, PATCH_DATA_LEVEL_KEY, UNKNOWN_VALUE);
        this.patchTimestamp = this.getPatchProperty(properties, BUILD_DATA_TIMESTAMP_KEY, UNKNOWN_VALUE);
        this.patchRevision = this.getPatchProperty(properties, BUILD_DATA_REVISION_KEY, UNKNOWN_VALUE);
        this.patchBranch = this.getPatchProperty(properties, BUILD_DATA_BRANCH_KEY, UNKNOWN_VALUE);
        Matcher matcher = KITIDPATTERN.matcher(this.buildVersion);
        this.kitID = matcher.matches() ? matcher.group(1) : UNKNOWN_VALUE;
    }

    private static final String detectEdition() {
        String edition = OPENSOURCE;
        try {
            Class.forName("com.tc.util.ProductInfoEnterpriseBundle");
            edition = ENTERPRISE;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return edition;
    }

    static Date parseTimestamp(String timestampString) throws ParseException {
        return timestampString == null ? null : new SimpleDateFormat(DATE_FORMAT).parse(timestampString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ProductInfo getInstance() {
        if (INSTANCE == null) {
            try {
                InputStream buildData = null;
                InputStream patchData = null;
                try {
                    buildData = ProductInfo.getData(BUILD_DATA_RESOURCE_NAME);
                    patchData = ProductInfo.getData(PATCH_DATA_RESOURCE_NAME);
                    INSTANCE = new ProductInfo(buildData, patchData);
                }
                finally {
                    IOUtils.closeQuietly(buildData);
                    IOUtils.closeQuietly(patchData);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static InputStream getData(String name) {
        CodeSource codeSource = ProductInfo.class.getProtectionDomain().getCodeSource();
        if (codeSource == null || codeSource.getLocation() == null) return ProductInfo.class.getResourceAsStream(name);
        URL source = codeSource.getLocation();
        if (source.getProtocol().equals("file") && source.toExternalForm().endsWith(".jar")) {
            try {
                URL res = new URL("jar:" + source.toExternalForm() + "!" + name);
                InputStream in = res.openStream();
                if (in == null) return ProductInfo.class.getResourceAsStream(name);
                return in;
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            catch (IOException e) {
                return ProductInfo.class.getResourceAsStream(name);
            }
        } else {
            File local;
            if (!source.getProtocol().equals("file") || !new File(source.getPath()).isDirectory() || !(local = new File(source.getPath(), name)).isFile()) return ProductInfo.class.getResourceAsStream(name);
            try {
                return new FileInputStream(local);
            }
            catch (FileNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static InputStream getBuildData() {
        return ProductInfo.getData(BUILD_DATA_RESOURCE_NAME);
    }

    static InputStream getPatchData() {
        return ProductInfo.getData(PATCH_DATA_RESOURCE_NAME);
    }

    private String getBuildProperty(Properties properties, String name, String defaultValue) {
        return this.getProperty(properties, BUILD_DATA_ROOT_KEY, name, defaultValue);
    }

    private String getPatchProperty(Properties properties, String name, String defaultValue) {
        return this.getProperty(properties, PATCH_DATA_ROOT_KEY, name, defaultValue);
    }

    private String getProperty(Properties properties, String root, String name, String defaultValue) {
        String out = properties.getProperty(root + name);
        if (StringUtils.isBlank(out)) {
            out = defaultValue;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printRawData() {
        try {
            InputStream buildData = null;
            try {
                buildData = ProductInfo.getBuildData();
                if (buildData != null) {
                    IOUtils.copy(buildData, System.out);
                }
            }
            finally {
                IOUtils.closeQuietly(buildData);
            }
            InputStream patchData = null;
            try {
                patchData = ProductInfo.getPatchData();
                if (patchData != null) {
                    IOUtils.copy(patchData, System.out);
                }
            }
            finally {
                IOUtils.closeQuietly(patchData);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean isDevMode() {
        return this.buildVersion.endsWith(UNKNOWN_VALUE);
    }

    public String moniker() {
        return this.moniker;
    }

    public String edition() {
        return this.edition;
    }

    public String version() {
        return this.buildVersion;
    }

    public String mavenArtifactsVersion() {
        return this.buildVersion;
    }

    public String buildVersion() {
        return this.buildVersion;
    }

    public String kitID() {
        return this.kitID;
    }

    public String buildTimestamp() {
        return this.timestamp;
    }

    public String buildTimestampAsString() {
        return this.timestamp;
    }

    public String buildBranch() {
        return this.branch;
    }

    public String copyright() {
        if (this.copyright == null) {
            this.copyright = bundleHelper.getString("copyright");
        }
        return this.copyright;
    }

    public String license() {
        return DEFAULT_LICENSE;
    }

    public String buildRevision() {
        return this.revision;
    }

    public boolean isPatched() {
        return !UNKNOWN_VALUE.equals(this.patchLevel);
    }

    public String patchLevel() {
        return this.patchLevel;
    }

    public String patchTimestamp() {
        return this.patchTimestamp;
    }

    public String patchTimestampAsString() {
        return this.patchTimestamp;
    }

    public String patchRevision() {
        return this.patchRevision;
    }

    public String patchBranch() {
        return this.patchBranch;
    }

    public String toShortString() {
        return this.moniker + " " + (this.isOpenSource() ? "" : this.edition + " ") + this.buildVersion;
    }

    public String toLongString() {
        return this.toShortString() + ", as of " + this.buildID();
    }

    public String buildID() {
        if (this.buildID == null) {
            this.buildID = this.buildTimestampAsString() + " (Revision " + this.revision + " from " + this.branch + ")";
        }
        return this.buildID;
    }

    public String toLongPatchString() {
        return this.toShortPatchString() + ", as of " + this.patchBuildID();
    }

    public String toShortPatchString() {
        return "Patch Level " + this.patchLevel;
    }

    public String patchBuildID() {
        return this.patchTimestampAsString() + " (Revision " + this.patchRevision + " from " + this.patchBranch + ")";
    }

    public boolean isOpenSource() {
        return OPENSOURCE.equalsIgnoreCase(this.edition);
    }

    public boolean isEnterprise() {
        return ENTERPRISE.equalsIgnoreCase(this.edition);
    }

    public String toString() {
        return this.toShortString();
    }
}

