/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.concurrent;

import com.tc.text.PrettyPrintable;
import com.tc.text.PrettyPrinter;
import com.tc.util.concurrent.TCConcurrentStore;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TCConcurrentMultiMap<K, V>
implements PrettyPrintable {
    private final AddCallBack<K, V> addCallback = new AddCallBack();
    private final AddAllCallBack<K, V> addAllCallback = new AddAllCallBack();
    private final RemoveCallBack<K, V> removeCallback = new RemoveCallBack();
    private final TCConcurrentStore<K, Set<V>> store;

    public TCConcurrentMultiMap() {
        this.store = new TCConcurrentStore();
    }

    public TCConcurrentMultiMap(int initialCapacity) {
        this.store = new TCConcurrentStore(initialCapacity);
    }

    public TCConcurrentMultiMap(int initialCapacity, float loadFactor) {
        this.store = new TCConcurrentStore(initialCapacity, loadFactor);
    }

    public TCConcurrentMultiMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.store = new TCConcurrentStore(initialCapacity, loadFactor, concurrencyLevel);
    }

    public boolean add(K key, V value) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        return (Boolean)this.store.executeUnderWriteLock(key, value, this.addCallback);
    }

    public boolean addAll(K key, Set<V> values) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        return (Boolean)this.store.executeUnderWriteLock(key, values, this.addAllCallback);
    }

    public boolean remove(K key, V value) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        return (Boolean)this.store.executeUnderWriteLock(key, value, this.removeCallback);
    }

    public Set<V> removeAll(K key) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        Set<V> set = this.store.remove(key);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public Set<V> get(K key) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        Set<V> set = this.store.get(key);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    public boolean containsKey(K key) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        Set<V> set = this.store.get(key);
        return set != null;
    }

    public int size() {
        return this.store.size();
    }

    public PrettyPrinter prettyPrint(PrettyPrinter out) {
        out.visit(this.store).flush();
        return out;
    }

    private static <T> Set<T> singleton(T t) {
        return new SingletonSet(t);
    }

    private static class SingletonSet<V>
    extends AbstractSet<V> {
        private final V value;

        private SingletonSet(V value) {
            this.value = value;
        }

        @Override
        public boolean add(V v) {
            if (v.equals(this.value)) {
                return false;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<V> iterator() {
            return Collections.singleton(this.value).iterator();
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object o) {
            return this.value.equals(o);
        }
    }

    private static final class RemoveCallBack<K, V>
    implements TCConcurrentStore.TCConcurrentStoreCallback<K, Set<V>> {
        private RemoveCallBack() {
        }

        @Override
        public Object callback(K key, Object value, Map<K, Set<V>> segment) {
            Set<V> set = segment.get(key);
            if (set == null) {
                return false;
            }
            if (set instanceof SingletonSet && set.contains(value)) {
                segment.remove(key);
                return true;
            }
            boolean removed = set.remove(value);
            if (set.isEmpty()) {
                segment.remove(key);
            } else if (removed && set.size() == 1) {
                segment.put(key, TCConcurrentMultiMap.singleton(set.iterator().next()));
            }
            return removed;
        }
    }

    private static final class AddAllCallBack<K, V>
    implements TCConcurrentStore.TCConcurrentStoreCallback<K, Set<V>> {
        private AddAllCallBack() {
        }

        @Override
        public Object callback(K key, Object values, Map<K, Set<V>> segment) {
            boolean newEntry = false;
            Set<V> set = segment.get(key);
            if (set == null) {
                set = new HashSet<V>();
                segment.put(key, set);
                newEntry = true;
            } else if (set instanceof SingletonSet) {
                set = new HashSet<V>(set);
                segment.put(key, set);
            }
            Set values2Add = (Set)values;
            set.addAll(values2Add);
            return newEntry;
        }
    }

    private static class AddCallBack<K, V>
    implements TCConcurrentStore.TCConcurrentStoreCallback<K, Set<V>> {
        private AddCallBack() {
        }

        @Override
        public Object callback(K key, Object value, Map<K, Set<V>> segment) {
            Set<V> set = segment.get(key);
            if (set == null) {
                segment.put(key, TCConcurrentMultiMap.singleton(value));
                return true;
            }
            if (set instanceof SingletonSet && !set.contains(value)) {
                set = new HashSet<V>(set);
                segment.put(key, set);
            }
            set.add(value);
            return false;
        }
    }
}

