/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapresource;

import java.util.concurrent.atomic.AtomicLong;
import org.terracotta.offheapresource.OffHeapResource;

class OffHeapResourceImpl
implements OffHeapResource {
    private final AtomicLong remaining;
    private final long capacity;

    OffHeapResourceImpl(long size) throws IllegalArgumentException {
        if (size < 0L) {
            throw new IllegalArgumentException("Resource size cannot be negative");
        }
        this.capacity = size;
        this.remaining = new AtomicLong(size);
    }

    @Override
    public boolean reserve(long size) throws IllegalArgumentException {
        if (size < 0L) {
            throw new IllegalArgumentException("Reservation size cannot be negative");
        }
        long current = this.remaining.get();
        while (current >= size) {
            if (this.remaining.compareAndSet(current, current - size)) {
                return true;
            }
            current = this.remaining.get();
        }
        return false;
    }

    @Override
    public void release(long size) throws IllegalArgumentException {
        if (size < 0L) {
            throw new IllegalArgumentException("Released size cannot be negative");
        }
        this.remaining.addAndGet(size);
    }

    @Override
    public long available() {
        return this.remaining.get();
    }

    @Override
    public long capacity() {
        return this.capacity;
    }
}

