/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapresource;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.offheapresource.OffHeapResource;
import org.terracotta.offheapresource.OffHeapResourceIdentifier;
import org.terracotta.offheapresource.OffHeapResourceImpl;
import org.terracotta.offheapresource.OffHeapResources;
import org.terracotta.offheapresource.PhysicalMemory;
import org.terracotta.offheapresource.config.MemoryUnit;
import org.terracotta.offheapresource.config.OffheapResourcesType;
import org.terracotta.offheapresource.config.ResourceType;
import org.terracotta.statistics.StatisticsManager;

public class OffHeapResourcesProvider
implements OffHeapResources {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffHeapResourcesProvider.class);
    private final Map<OffHeapResourceIdentifier, OffHeapResource> resources = new HashMap<OffHeapResourceIdentifier, OffHeapResource>();
    private static final BigInteger MAX_LONG_PLUS_ONE = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);

    public OffHeapResourcesProvider(OffheapResourcesType configuration) {
        if (this.resources.isEmpty()) {
            long totalSize = 0L;
            for (ResourceType r : configuration.getResource()) {
                long size = OffHeapResourcesProvider.longValueExact(OffHeapResourcesProvider.convert(r.getValue(), r.getUnit()));
                totalSize += size;
                OffHeapResourceImpl offHeapResource = new OffHeapResourceImpl(size);
                OffHeapResourceIdentifier identifier = OffHeapResourceIdentifier.identifier(r.getName());
                this.resources.put(identifier, offHeapResource);
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("discriminator", "OffHeapResource");
                properties.put("offHeapResourceIdentifier", identifier.getName());
                StatisticsManager.createPassThroughStatistic((Object)offHeapResource, (String)"allocatedMemory", new HashSet<String>(Arrays.asList("OffHeapResource", "tier")), properties, () -> offHeapResource.capacity() - offHeapResource.available());
            }
            Long physicalMemory = PhysicalMemory.totalPhysicalMemory();
            if (physicalMemory != null && totalSize > physicalMemory) {
                LOGGER.warn("More offheap configured than there is physical memory [{} > {}]", (Object)totalSize, (Object)physicalMemory);
            }
        } else {
            throw new IllegalStateException("Resources already initialized");
        }
    }

    @Override
    public Set<OffHeapResourceIdentifier> getAllIdentifiers() {
        return Collections.unmodifiableSet(this.resources.keySet());
    }

    @Override
    public OffHeapResource getOffHeapResource(OffHeapResourceIdentifier identifier) {
        return this.resources.get(identifier);
    }

    static BigInteger convert(BigInteger value, MemoryUnit unit) {
        switch (unit) {
            case B: {
                return value.shiftLeft(0);
            }
            case K_B: {
                return value.shiftLeft(10);
            }
            case MB: {
                return value.shiftLeft(20);
            }
            case GB: {
                return value.shiftLeft(30);
            }
            case TB: {
                return value.shiftLeft(40);
            }
            case PB: {
                return value.shiftLeft(50);
            }
        }
        throw new IllegalArgumentException("Unknown unit " + (Object)((Object)unit));
    }

    static long longValueExact(BigInteger value) {
        if (value.compareTo(MAX_LONG_PLUS_ONE) < 0) {
            return value.longValue();
        }
        throw new ArithmeticException("BigInteger out of long range");
    }
}

