/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapresource;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PhysicalMemory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhysicalMemory.class);
    private static final OperatingSystemMXBean OS_BEAN = ManagementFactory.getOperatingSystemMXBean();

    PhysicalMemory() {
    }

    public static Long totalPhysicalMemory() {
        return (Long)PhysicalMemory.getAttribute("getTotalPhysicalMemorySize");
    }

    public static Long freePhysicalMemory() {
        return (Long)PhysicalMemory.getAttribute("getFreePhysicalMemorySize");
    }

    public static Long totalSwapSpace() {
        return (Long)PhysicalMemory.getAttribute("getTotalSwapSpaceSize");
    }

    public static Long freeSwapSpace() {
        return (Long)PhysicalMemory.getAttribute("getFreeSwapSpaceSize");
    }

    public static Long ourCommittedVirtualMemory() {
        return (Long)PhysicalMemory.getAttribute("getCommittedVirtualMemorySize");
    }

    private static <T> T getAttribute(String name) {
        LOGGER.trace("Bean lookup for {}", (Object)name);
        for (Class<?> s = OS_BEAN.getClass(); s != null; s = s.getSuperclass()) {
            try {
                Object result = s.getMethod(name, new Class[0]).invoke((Object)OS_BEAN, new Object[0]);
                LOGGER.trace("Bean lookup successful using {}, got {}", s, result);
                return (T)result;
            }
            catch (SecurityException e) {
                LOGGER.trace("Bean lookup failed on {}", s, (Object)e);
                continue;
            }
            catch (NoSuchMethodException e) {
                LOGGER.trace("Bean lookup failed on {}", s, (Object)e);
                continue;
            }
            catch (IllegalAccessException e) {
                LOGGER.trace("Bean lookup failed on {}", s, (Object)e);
                continue;
            }
            catch (IllegalArgumentException e) {
                LOGGER.trace("Bean lookup failed on {}", s, (Object)e);
                continue;
            }
            catch (InvocationTargetException e) {
                LOGGER.trace("Bean lookup failed on {}", s, (Object)e);
            }
        }
        for (Class<?> i : OS_BEAN.getClass().getInterfaces()) {
            try {
                Object result = i.getMethod(name, new Class[0]).invoke((Object)OS_BEAN, new Object[0]);
                LOGGER.trace("Bean lookup successful using {}, got {}", i, result);
                return (T)result;
            }
            catch (SecurityException e) {
                LOGGER.trace("Bean lookup failed on {}", i, (Object)e);
            }
            catch (NoSuchMethodException e) {
                LOGGER.trace("Bean lookup failed on {}", i, (Object)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.trace("Bean lookup failed on {}", i, (Object)e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.trace("Bean lookup failed on {}", i, (Object)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.trace("Bean lookup failed on {}", i, (Object)e);
            }
        }
        LOGGER.trace("Returning null for {}", (Object)name);
        return null;
    }
}

