/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapresource.management;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.PlatformConfiguration;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.management.service.monitoring.ConsumerManagementRegistry;
import org.terracotta.management.service.monitoring.ManagementPlugin;
import org.terracotta.management.service.monitoring.ManagementPluginContext;
import org.terracotta.offheapresource.OffHeapResourceIdentifier;
import org.terracotta.offheapresource.OffHeapResources;
import org.terracotta.offheapresource.management.OffHeapResourceBinding;
import org.terracotta.offheapresource.management.OffHeapResourceSettingsManagementProvider;
import org.terracotta.offheapresource.management.OffHeapResourceStatisticsManagementProvider;

public class OffHeapResourceManagementPlugin
implements ManagementPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffHeapResourceManagementPlugin.class);

    public void registerServerManagementProviders(ManagementPluginContext pluginContext) {
        PlatformConfiguration platformConfiguration = pluginContext.getPlatformConfiguration();
        ConsumerManagementRegistry consumerManagementRegistry = pluginContext.getConsumerManagementRegistry();
        long consumerId = pluginContext.getConsumerId();
        Collection offHeapResources = platformConfiguration.getExtendedConfiguration(OffHeapResources.class);
        if (!offHeapResources.isEmpty()) {
            consumerManagementRegistry.addManagementProvider((ManagementProvider)new OffHeapResourceSettingsManagementProvider());
            consumerManagementRegistry.addManagementProvider((ManagementProvider)new OffHeapResourceStatisticsManagementProvider());
            for (OffHeapResources offHeapResource : offHeapResources) {
                for (OffHeapResourceIdentifier identifier : offHeapResource.getAllIdentifiers()) {
                    LOGGER.trace("[0] registerServerManagementProviders({}, OffHeapResource:{})", (Object)consumerId, (Object)identifier.getName());
                    consumerManagementRegistry.register((Object)new OffHeapResourceBinding(identifier.getName(), offHeapResource.getOffHeapResource(identifier)));
                }
            }
        }
    }
}

