/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.tiering;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.config.ResourceType;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.internal.util.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.core.spi.function.Function;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.StoreAccessException;
import org.ehcache.core.spi.store.tiering.CachingTier;
import org.ehcache.core.spi.store.tiering.HigherCachingTier;
import org.ehcache.core.spi.store.tiering.LowerCachingTier;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.statistics.StatisticsManager;

public class CompoundCachingTier<K, V>
implements CachingTier<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompoundCachingTier.class);
    private final HigherCachingTier<K, V> higher;
    private final LowerCachingTier<K, V> lower;
    private volatile CachingTier.InvalidationListener<K, V> invalidationListener;

    public CompoundCachingTier(HigherCachingTier<K, V> higher, final LowerCachingTier<K, V> lower) {
        this.higher = higher;
        this.lower = lower;
        this.higher.setInvalidationListener(new CachingTier.InvalidationListener<K, V>(){

            @Override
            public void onInvalidation(K key, final Store.ValueHolder<V> valueHolder) {
                try {
                    CompoundCachingTier.this.lower.installMapping(key, new Function<K, Store.ValueHolder<V>>(){

                        @Override
                        public Store.ValueHolder<V> apply(K k) {
                            return valueHolder;
                        }
                    });
                }
                catch (StoreAccessException cae) {
                    CompoundCachingTier.this.notifyInvalidation(key, valueHolder);
                    LOGGER.warn("Error overflowing '{}' into lower caching tier {}", new Object[]{key, lower, cae});
                }
            }
        });
        StatisticsManager.associate(higher).withParent(this);
        StatisticsManager.associate(lower).withParent(this);
    }

    private void notifyInvalidation(K key, Store.ValueHolder<V> p) {
        CachingTier.InvalidationListener<K, V> invalidationListener = this.invalidationListener;
        if (invalidationListener != null) {
            invalidationListener.onInvalidation(key, p);
        }
    }

    @Override
    public Store.ValueHolder<V> getOrComputeIfAbsent(K key, final Function<K, Store.ValueHolder<V>> source) throws StoreAccessException {
        try {
            return this.higher.getOrComputeIfAbsent(key, new Function<K, Store.ValueHolder<V>>(){

                @Override
                public Store.ValueHolder<V> apply(K k) {
                    try {
                        Store.ValueHolder valueHolder = CompoundCachingTier.this.lower.getAndRemove(k);
                        if (valueHolder != null) {
                            return valueHolder;
                        }
                        return (Store.ValueHolder)source.apply(k);
                    }
                    catch (StoreAccessException cae) {
                        throw new ComputationException(cae);
                    }
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getStoreAccessException();
        }
    }

    @Override
    public void invalidate(final K key) throws StoreAccessException {
        try {
            this.higher.silentInvalidate(key, new Function<Store.ValueHolder<V>, Void>(){

                @Override
                public Void apply(Store.ValueHolder<V> mappedValue) {
                    try {
                        if (mappedValue != null) {
                            CompoundCachingTier.this.notifyInvalidation(key, mappedValue);
                        } else {
                            CompoundCachingTier.this.lower.invalidate(key);
                        }
                    }
                    catch (StoreAccessException cae) {
                        throw new ComputationException(cae);
                    }
                    return null;
                }
            });
        }
        catch (ComputationException ce) {
            throw ce.getStoreAccessException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAll() throws StoreAccessException {
        try {
            this.higher.silentInvalidateAll(new BiFunction<K, Store.ValueHolder<V>, Void>(){

                @Override
                public Void apply(K key, Store.ValueHolder<V> mappedValue) {
                    if (mappedValue != null) {
                        CompoundCachingTier.this.notifyInvalidation(key, mappedValue);
                    }
                    return null;
                }
            });
        }
        finally {
            this.lower.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAllWithHash(long hash) throws StoreAccessException {
        try {
            this.higher.silentInvalidateAllWithHash(hash, new BiFunction<K, Store.ValueHolder<V>, Void>(){

                @Override
                public Void apply(K key, Store.ValueHolder<V> mappedValue) {
                    if (mappedValue != null) {
                        CompoundCachingTier.this.notifyInvalidation(key, mappedValue);
                    }
                    return null;
                }
            });
        }
        finally {
            this.lower.invalidateAllWithHash(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws StoreAccessException {
        try {
            this.higher.clear();
        }
        finally {
            this.lower.clear();
        }
    }

    @Override
    public void setInvalidationListener(CachingTier.InvalidationListener<K, V> invalidationListener) {
        this.invalidationListener = invalidationListener;
        this.lower.setInvalidationListener(invalidationListener);
    }

    @Override
    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        ArrayList<CacheConfigurationChangeListener> listeners = new ArrayList<CacheConfigurationChangeListener>();
        listeners.addAll(this.higher.getConfigurationChangeListeners());
        listeners.addAll(this.lower.getConfigurationChangeListeners());
        return listeners;
    }

    @ServiceDependencies(value={HigherCachingTier.Provider.class, LowerCachingTier.Provider.class})
    public static class Provider
    implements CachingTier.Provider {
        private volatile ServiceProvider<Service> serviceProvider;
        private final ConcurrentMap<CachingTier<?, ?>, Map.Entry<HigherCachingTier.Provider, LowerCachingTier.Provider>> providersMap = new ConcurrentWeakIdentityHashMap();

        @Override
        public <K, V> CachingTier<K, V> createCachingTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            if (this.serviceProvider == null) {
                throw new RuntimeException("ServiceProvider is null.");
            }
            Collection<HigherCachingTier.Provider> higherProviders = this.serviceProvider.getServicesOfType(HigherCachingTier.Provider.class);
            if (higherProviders.size() != 1) {
                throw new IllegalStateException("Cannot handle multiple higher tier providers");
            }
            HigherCachingTier.Provider higherProvider = higherProviders.iterator().next();
            HigherCachingTier<K, V> higherCachingTier = higherProvider.createHigherCachingTier(storeConfig, serviceConfigs);
            Collection<LowerCachingTier.Provider> lowerProviders = this.serviceProvider.getServicesOfType(LowerCachingTier.Provider.class);
            if (lowerProviders.size() != 1) {
                throw new IllegalStateException("Cannot handle multiple lower tier providers");
            }
            LowerCachingTier.Provider lowerProvider = lowerProviders.iterator().next();
            LowerCachingTier<K, V> lowerCachingTier = lowerProvider.createCachingTier(storeConfig, serviceConfigs);
            CompoundCachingTier<K, V> compoundCachingTier = new CompoundCachingTier<K, V>(higherCachingTier, lowerCachingTier);
            this.providersMap.put(compoundCachingTier, new AbstractMap.SimpleEntry<HigherCachingTier.Provider, LowerCachingTier.Provider>(higherProvider, lowerProvider));
            return compoundCachingTier;
        }

        @Override
        public void releaseCachingTier(CachingTier<?, ?> resource) {
            if (!this.providersMap.containsKey(resource)) {
                throw new IllegalArgumentException("Given caching tier is not managed by this provider : " + resource);
            }
            CompoundCachingTier compoundCachingTier = (CompoundCachingTier)resource;
            Map.Entry entry = (Map.Entry)this.providersMap.get(resource);
            ((HigherCachingTier.Provider)entry.getKey()).releaseHigherCachingTier(compoundCachingTier.higher);
            ((LowerCachingTier.Provider)entry.getValue()).releaseCachingTier(compoundCachingTier.lower);
        }

        @Override
        public void initCachingTier(CachingTier<?, ?> resource) {
            if (!this.providersMap.containsKey(resource)) {
                throw new IllegalArgumentException("Given caching tier is not managed by this provider : " + resource);
            }
            CompoundCachingTier compoundCachingTier = (CompoundCachingTier)resource;
            Map.Entry entry = (Map.Entry)this.providersMap.get(resource);
            ((LowerCachingTier.Provider)entry.getValue()).initCachingTier(compoundCachingTier.lower);
            ((HigherCachingTier.Provider)entry.getKey()).initHigherCachingTier(compoundCachingTier.higher);
        }

        @Override
        public int rankCachingTier(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?>> serviceConfigs) {
            return ((Object)resourceTypes).equals(Collections.unmodifiableSet(EnumSet.of(ResourceType.Core.HEAP, ResourceType.Core.OFFHEAP))) ? 2 : 0;
        }

        @Override
        public void start(ServiceProvider<Service> serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        @Override
        public void stop() {
            this.serviceProvider = null;
            this.providersMap.clear();
        }
    }

    static class ComputationException
    extends RuntimeException {
        public ComputationException(StoreAccessException cause) {
            super(cause);
        }

        public StoreAccessException getStoreAccessException() {
            return (StoreAccessException)this.getCause();
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

